@extends('Admin.layouts.master')

@section('title','blogs')
@section('css')

@endsection

@section('content')

<div class="card">
  <div class="card-header pb-0">
    <h5>Add BLog</h5>
  </div>
  <form class="form theme-form" action="{{route('Admin.blog.store')}}" method="post" enctype="multipart/form-data">
    @csrf

    <div class="card-body">
      <div class="row">

        
        <div class="col-4">
          <div class="mb-3">
            <label class="form-label" for="exampleFormControlInput1">Image Title </label>
            <input class="form-control @error('img_title') is-invalid fparsley-error parsley-error @enderror" name="img_title" id="exampleFormControlInput1" type="text" placeholder="Image Title" value="{{old('img_title')}}">
          </div>
        </div>
        
        <div class="col-4">
          <div class="mb-3">
            <label class="form-label" for="exampleFormControlInput1"> Alt Title </label>
            <input class="form-control @error('alt_title') is-invalid fparsley-error parsley-error @enderror" name="alt_title" id="exampleFormControlInput1" type="text" placeholder="Alt Title" value="{{old('alt_title')}}">
          
          </div>
        </div>
        
        <div class="col-4">
          <div class="mb-3">
            <label class="form-label" for="exampleFormControlInput1"> URL Name </label>
            <input class="form-control @error('url_name') is-invalid fparsley-error parsley-error @enderror" name="url_name" id="exampleFormControlInput1" type="text" placeholder="URL Name" value="{{old('url_name')}}">
          </div>
        </div>
        
        
        <div class="col-6">
          <div class="mb-3">
            <label class="form-label" for="exampleFormControlInput1">Title in English </label>
            <input class="form-control @error('title_en') is-invalid fparsley-error parsley-error @enderror" name="title_en" id="exampleFormControlInput1" type="text" placeholder="title" value="{{old('title_en')}}">
            @error('title_en')
            <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2" role="alert">
              <p>{{ $message }}</p>
            </span>
            @enderror
          </div>
        </div>
        
        
        <div class="col-6">
          <div class="mb-3">
            <label class="form-label" for="exampleFormControlInput1"> Title in Arabic </label>
            <input class="form-control @error('title_ar') is-invalid fparsley-error parsley-error @enderror" name="title_ar" id="exampleFormControlInput1" type="text" placeholder="title" value="{{old('title_ar')}}">
            @error('title_ar')
            <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2" role="alert">
              <p>{{ $message }}</p>
            </span>
            @enderror
          </div>
        </div>

      </div>
      
      
            <div class="row">
        <div class="col-12">
          <div class="mb-3">
            <label class="form-label" for="exampleFormControlInput1">Small Description in English </label>
            <textarea class="form-control @error('description_en') is-invalid fparsley-error parsley-error @enderror" name="description_en" id="exampleFormControlTextarea4" rows="2">{{old('description_en')}}</textarea>
            @error('description_en')
            <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2" role="alert">
              <p>{{ $message }}</p>
            </span>
            @enderror
          </div>
        </div>
        <div class="col-12">
          <div class="mb-3">
            <label class="form-label" for="exampleFormControlInput1">Small Description in Arabic </label>
            <textarea class="form-control @error('description_ar') is-invalid fparsley-error parsley-error @enderror" name="description_ar" id="exampleFormControlTextarea4" rows="2">{{old('description_ar')}}</textarea>
            @error('description_ar')
            <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2" role="alert">
              <p>{{ $message }}</p>
            </span>
            @enderror
          </div>
        </div>
      </div>
      
      
      <div class="row">
        <div class="col-12">
          <div class="mb-3">
            <label class="form-label" for="exampleFormControlInput1">Meta Description </label>
            <textarea class="form-control @error('description_en') is-invalid fparsley-error parsley-error @enderror" name="meta_description" id="exampleFormControlTextarea4" rows="2">{{old('meta_description')}}</textarea>
            
          </div>
        </div>
        <div class="col-12">
          <div class="mb-3">
            <label class="form-label" for="exampleFormControlInput1">Meta Keywords</label>
            <textarea class="form-control @error('description_ar') is-invalid fparsley-error parsley-error @enderror" name="meta_kewords" id="exampleFormControlTextarea4" rows="2">{{old('meta_kewords')}}</textarea>
            
          </div>
        </div>
      </div>
      
      
      
      <div class="row">
        <div class="col-12">
          <div class="mb-3">
            <label class="form-label" for="exampleFormControlInput1">Description in English </label>
            <textarea class="form-control @error('details_en') is-invalid fparsley-error parsley-error @enderror ckeditor" name="details_en" id="exampleFormControlTextarea4" >{{old('details_en')}}</textarea>
            @error('description_en')
            <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2" role="alert">
              <p>{{ $message }}</p>
            </span>
            @enderror
          </div>
        </div>
        <div class="col-12">
          <div class="mb-3">
            <label class="form-label" for="exampleFormControlInput1">Description in Arabic </label>
            <textarea class="form-control @error('details_ar') is-invalid fparsley-error parsley-error @enderror ckeditor" name="details_ar" id="exampleFormControlTextarea4" >{{old('details_ar')}}</textarea>
            @error('description_ar')
            <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2" role="alert">
              <p>{{ $message }}</p>
            </span>
            @enderror
          </div>
        </div>
      </div>
      
      
      <div class="row">
        <div class="col-6">
          <div class="mb-3">
            <label class="form-label" for="exampleFormControlInput1">Category in English </label>
            <input class="form-control @error('category_en') is-invalid fparsley-error parsley-error @enderror" name="category_en" id="exampleFormControlInput1" type="text" placeholder="category" value="{{old('category_en')}}">
            @error('category_en')
            <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2" role="alert">
              <p>{{ $message }}</p>
            </span>
            @enderror
          </div>
        </div>
        <div class="col-6">
          <div class="mb-3">
            <label class="form-label" for="exampleFormControlInput1"> Category in Arabic </label>
            <input class="form-control @error('category_ar') is-invalid fparsley-error parsley-error @enderror" name="category_ar" id="exampleFormControlInput1" type="text" placeholder="category" value="{{old('category_ar')}}">
            @error('category_ar')
            <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2" role="alert">
              <p>{{ $message }}</p>
            </span>
            @enderror
          </div>
        </div>

      </div>
      <div class="row">

        <div class="col-8">
          <div class="mb-3">
            <label class="form-label" for="exampleFormControlInput1">image </label>
            <input class="form-control @error('image') is-invalid fparsley-error parsley-error @enderror" name="image" type="file">
            @error('image')
            <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2" role="alert">
              <p>{{ $message }}</p>
            </span>
            @enderror
          </div>
        </div>

      </div>

      <div class="row">



        <div class="card-footer text-end">
          <button class="btn btn-primary" type="submit">Add</button>
          <input class="btn btn-light" type="reset" value="Cancel">
        </div>
      </div>
  </form>
</div>
@endsection

@section('js')
<script src="https://taqiviolet.com/admin/assets/js/editor/ckeditor/ckeditor.custom.js"></script>
<script src="https://taqiviolet.com/admin/assets/js/editor/ckeditor/ckeditor.js"></script>

@endsection