<!DOCTYPE html>

<html lang="en">
	<!--begin::Head-->
	<head><base href="">
		<meta charset="utf-8" />
		<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>" />
		<meta name="description" content="Metronic admin dashboard live demo. Check out all the features of the admin panel. A large number of settings, additional services and widgets." />
		<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
		<link rel="canonical" href="https://keenthemes.com/metronic" />
    <title><?php echo $__env->yieldContent('title'); ?></title>
   <?php echo $__env->make('Admin.layouts.head', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
 </head>

	<!--begin::Body-->
	<body id="kt_body" class="header-fixed header-mobile-fixed subheader-enabled subheader-fixed aside-enabled aside-fixed aside-minimize-hoverable page-loading">
		<!--begin::Main-->
		<!--begin::Header Mobile-->
		<div id="kt_header_mobile" class="header-mobile align-items-center header-mobile-fixed">
			<!--begin::Logo-->
			<a href="index.html">
				<img alt="Logo" src="<?php echo e(asset('assets/Admin/assets/media/logos/logo-light.png')); ?>" />
			</a>
			<!--end::Logo-->
			<!--begin::Toolbar-->
			<div class="d-flex align-items-center">
				<!--begin::Aside Mobile Toggle-->
				<button class="btn p-0 burger-icon burger-icon-left" id="kt_aside_mobile_toggle">
					<span></span>
				</button>
				<!--end::Aside Mobile Toggle-->
				<!--begin::Header Menu Mobile Toggle-->
				<button class="btn p-0 burger-icon ml-4" id="kt_header_mobile_toggle">
					<span></span>
				</button>
				<!--end::Header Menu Mobile Toggle-->
				<!--begin::Topbar Mobile Toggle-->
				<button class="btn btn-hover-text-primary p-0 ml-2" id="kt_header_mobile_topbar_toggle">
					<span class="svg-icon svg-icon-xl">
						<!--begin::Svg Icon | path:assets/media/svg/icons/General/User.svg-->
						<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
							<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
								<polygon points="0 0 24 0 24 24 0 24" />
								<path d="M12,11 C9.790861,11 8,9.209139 8,7 C8,4.790861 9.790861,3 12,3 C14.209139,3 16,4.790861 16,7 C16,9.209139 14.209139,11 12,11 Z" fill="#000000" fill-rule="nonzero" opacity="0.3" />
								<path d="M3.00065168,20.1992055 C3.38825852,15.4265159 7.26191235,13 11.9833413,13 C16.7712164,13 20.7048837,15.2931929 20.9979143,20.2 C21.0095879,20.3954741 20.9979143,21 20.2466999,21 C16.541124,21 11.0347247,21 3.72750223,21 C3.47671215,21 2.97953825,20.45918 3.00065168,20.1992055 Z" fill="#000000" fill-rule="nonzero" />
							</g>
						</svg>
						<!--end::Svg Icon-->
					</span>
				</button>
				<!--end::Topbar Mobile Toggle-->
			</div>
			<!--end::Toolbar-->
		</div>
		<!--end::Header Mobile-->
		<div class="d-flex flex-column flex-root">
			<!--begin::Page-->
			<div class="d-flex flex-row flex-column-fluid page">
		<?php echo $__env->make('Admin.layouts.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
		<!--begin::Wrapper-->
		<div class="d-flex flex-column flex-row-fluid wrapper" id="kt_wrapper">
		<?php echo $__env->make('Admin.layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
		<!--begin::Content-->

		<!--start::MaoMenu-->

		<?php echo $__env->make('Admin.layouts.mapMenu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

		<div class="content d-flex flex-column flex-column-fluid" id="kt_content">
            <?php echo $__env->yieldContent('content'); ?>
			 </div>
					<!--end::Content-->
					<?php echo $__env->make('Admin.layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

					</div>
				<!--end::Wrapper-->
			</div>
			<!--end::Page-->
		</div>
		<!--end::Main-->

<?php echo $__env->make('Admin.layouts.footerjs', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('sweetalert::alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>



<script>
    $('.typeSearch').on('change', function(){
        var searchType = $(this).val();
        $('#quick-search-result-elements').removeClass('show-search');

        $('#search-input').on('keyup', function () {
            var inputValue = $(this).val();
            var $quick_search_dropdown = $('.quick-search.quick-search-dropdown');
            $.ajax({
                url: '<?php echo e(route("admin.search")); ?>',
                method: 'GET',
                data: {
                    '_token': '<?php echo e(csrf_token()); ?>',
                    'title': inputValue,
                    'typeSearch': searchType,
                },
                success: function (data) {
                    if (data.length > 0) {
                        $quick_search_dropdown.addClass('quick-search-has-result');
                        result_elements = '';
                        data.forEach(element => {
                            result = `<div class="d-flex align-items-center flex-grow-1 mb-2 show-search">
                                <div class="d-flex flex-column ml-3 mt-2 mb-2">
                                    <a href="<?php echo e(url('admin/${searchType}/edit/${element.id}')); ?>" class="font-weight-bold text-dark text-hover-primary">
                                        ${element.title ?? element.name}
                                    </a>
                                </div>
                            </div>`;
                            result_elements += result;
                        });
                        $('#quick-search-result-elements').html(result_elements);

                    } else {
                        $quick_search_dropdown.removeClass('quick-search-has-result');
                        $('#quick-search-result-elements').html('');

                    }
                },
                error: function (error) {
                    $quick_search_dropdown.removeClass('quick-search-has-result');
                    $('#quick-search-result-elements').html('');
                    console.error(error);

                }
            });
        });
    })
</script>


</body>
</html>
<?php /**PATH /home/active4web/public_html/candly/resources/views/Admin/layouts/master.blade.php ENDPATH**/ ?>