<?php

use Livewire\Livewire;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Front\AuthController;
use App\Http\Controllers\Front\FrontController;
use App\Http\Controllers\Front\MasteryController;
use App\Http\Controllers\Front\StudentController;
use App\Http\Controllers\Front\DashboardController;
use App\Http\Controllers\Front\SubscribeController;
use App\Http\Controllers\Front\LessonQuizController;
use App\Http\Controllers\Front\SocialAuthController;
use App\Http\Repositories\Front\DashboardRepository;
use App\Http\Controllers\Front\PlacementTestController;
use App\Http\Controllers\Front\ForgetPasswordController;
use SebastianBergmann\CodeCoverage\Report\Html\Dashboard;
use App\Http\Controllers\Front\EmailVerificationController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

//Auth
Route::get('/register', [AuthController::class, 'registerPage'])->name('registerpage');
Route::post('/register', [AuthController::class, 'register'])->name('register');
Route::get('/login', [AuthController::class, 'loginPage'])->name('loginpage');
Route::post('/login', [AuthController::class, 'login'])->name('login');
Route::post('/logout', [AuthController::class, 'logout'])->name('logout');
Route::get('email/verification-notification', [EmailVerificationController::class, 'sendVerificationEmail'])->name('sendverificationemail')->middleware('auth');
Route::get('verify-email/{id}/{hash}', [EmailVerificationController::class, 'verify'])->name('verification.verify');
Route::get('/auth/google/redirect', [SocialAuthController::class, 'googleRedirect'])->name('googleredirect');
Route::get('/auth/google/callback', [SocialAuthController::class, 'googleCallback'])->name('googlecallback');
Route::get('/auth/facebook/redirect', [SocialAuthController::class, 'facebookRedirect'])->name('facebookredirect');
Route::get('/auth/facebook/callback', [SocialAuthController::class, 'facebookCallback'])->name('facebookcallback');
Route::get('/forgetpassword', [ForgetPasswordController::class, 'index'])->name('forgetpassword');
Route::post('/sendemail', [ForgetPasswordController::class, 'getEmail'])->name('getemail');
Route::get('/resetPasswordpage', [ForgetPasswordController::class, 'changePasswordPage'])->name('resetpasswordpage');
Route::post('/resetPassword', [ForgetPasswordController::class, 'resetPassword']);
//Registerpages
Route::group(['as' => 'auth.', 'middleware' => 'auth'], function () {
    Route::get('/getname', [AuthController::class, 'getName'])->name('getName');
    Route::put('/storename', [AuthController::class, 'storeName'])->name('storeName');
    Route::get('/getcountry', [AuthController::class, 'getCountry'])->name('getCountry');
    Route::put('/storecountry', [AuthController::class, 'storeCountry'])->name('storeCountry');

    // Route::get('/sendnotifications', [AuthController::class, 'sendNotification'])->name('sendNotification');
    // Route::put('/acceptnotifications', [AuthController::class, 'acceptNotification'])->name('acceptNotification');

    Route::get('/email-verification-page', [AuthController::class, 'emailVerificationPage'])->name('show-email-verification');
    Route::put('/email-verification', [AuthController::class, 'emailVerificationStore'])->name('email-verification.update');

    Route::get('/uploadimage', [AuthController::class, 'uploadImg'])->name('uploadImg');
    Route::put('/storeimage', [AuthController::class, 'storeImg'])->name('storeImg');
    Route::get('/levelquiz', [AuthController::class, 'levelQuiz'])->name('levelQuiz');
    Route::get('/placementtest', [PlacementTestController::class, 'index'])->name('test');
    Route::get('/test/result/{id}', [PlacementTestController::class, 'result'])->name('testresult');
});

Route::get('/email-verification', [FrontController::class, 'verifyPage'])->name('verify-page');
Route::post('/email-verification', [FrontController::class, 'verifyAccount'])->name('verify-account');

//front

Route::group(['as' => 'front.', 'middleware' => ['verified']], function () {

    Route::get('/', [FrontController::class, 'index'])->name('index');
    Route::get('sub/{slug}', [FrontController::class, 'subpage'])->name('subpage');
    Route::get('/about', [FrontController::class, 'about'])->name('about');
    Route::get('/contact', [FrontController::class, 'contact'])->name('contact');
    Route::get('/howtoregister', [FrontController::class, 'howToRegister'])->name('howtoregister')->middleware('guest');
    // Route::get('/video', [FrontController::class, 'video'])->name('video');
    Route::get('/policy', [FrontController::class, 'policy'])->name('policy');
    Route::get('/terms', [FrontController::class, 'terms'])->name('terms');
    Route::post('/contactstore', [FrontController::class, 'contactstore'])->name('contactstore');

    Route::group(['as' => 'dashboard.', 'middleware' => 'auth'], function () {
        Route::get('/dashoard/{id}', [DashboardController::class, 'index'])->name('index');
        Route::get('/unitlesson/{id}', [DashboardController::class, 'unitLesson'])->name('unitLesson');
        Route::get('/blog', [DashboardController::class, 'blog'])->name('blog');
        Route::get('/blogsingle/{id}', [DashboardController::class, 'singleBlog'])->name('singleBlog');
        Route::get('/dashboardsign', [DashboardController::class, 'dashboardSign'])->name('dashboardSign');
        Route::get('/dashboardplacement', [DashboardController::class, 'dashboardPlacement'])->name('dashboardPlacement');
        Route::get('/lessonflash/{id}', [DashboardController::class, 'lessonFlash'])->name('lessonFlash');
        Route::get('/lessonpractice/{id}', [DashboardController::class, 'lessonPractice'])->name('lessonpractice');
        Route::post('/lessonfaq', [DashboardController::class, 'lessonFaq'])->name('lessonfaqstore');
        Route::post('/lessonReview', [DashboardController::class, 'lessonReview'])->name('lessonreviewstore');
        Route::get('/lessonRate/{rate}/{lesson_id}', [DashboardController::class, 'lessonRate'])->name('lessonratestore');

        Route::get('/price', [DashboardController::class, 'price'])->name('price');

        Route::get('/startcourse/beginner', [DashboardController::class, 'startCourseBeginner'])->name('startcourse');
        Route::get('/startcourse/testresult/{id}', [DashboardController::class, 'startCourseTestResult'])->name('startcourse.testresult');
        Route::get('guides', [DashboardController::class, 'guides'])->name('guides');
        Route::get('guides/details/{id}', [DashboardController::class, 'guidesDetails'])->name('guidesdetails');
        Route::get('guides/setting', [DashboardController::class, 'guidesSetting'])->name('guidessetting');
        Route::get('contact/chat', [DashboardController::class, 'contact'])->name('contactchat');
        Route::get('guides/account/{id}', [DashboardController::class, 'guidesAccount'])->name('guidesAccount');
        Route::get('/lesson/quiz/{id}', [LessonQuizController::class, 'index'])->name('lessonquiz');
        Route::get('/quiz/result/{id}', [LessonQuizController::class, 'result'])->name('quizresult');
        Route::get('/profile-possword', [StudentController::class, 'changepassword'])->name('profile-possword');
        Route::put('/updatepossword', [StudentController::class, 'updatepassword'])->name('updatepossword');
        Route::get('/profile-subscribes', [StudentController::class, 'subscribes'])->name('profile-subscribes');
        Route::get('/profile-setting', [StudentController::class, 'edit'])->name('profile-setting');
        Route::get('/deactive/account/send', [StudentController::class, 'deactiveAccount'])->name('deactiveaccount');
        Route::get('/deactive/account/{id}', [StudentController::class, 'deactive'])->name('deactive');
        Route::put('/profileupdate', [StudentController::class, 'update'])->name('profileupdate');
        Route::get('/nextlesson/{id}', [LessonQuizController::class, 'nextLesson'])->name('nextlesson');
        Route::get('/complete/lesson/{id}', [LessonQuizController::class, 'completeLesson'])->name('completelesson');
        Route::post('/messages', [DashboardController::class, 'messages'])->name('messages');
        Route::get('/notifications', [DashboardController::class, 'notifications'])->name('notification');
        Route::get('/notification/markread/{id}', [DashboardController::class, 'markRead'])->name('markread');
        Route::get('/notification/markallread', [DashboardController::class, 'markAllRead'])->name('markallread');
        Route::get('/next/lesson/{id}', [DashboardController::class, 'next'])->name('next');
        Route::get('/previous/lesson/{id}', [DashboardController::class, 'previous'])->name('previous');


        Route::get('/mastery', [MasteryController::class, 'mastery'])->name('mastery');
        Route::get('/mastery/flashcard', [MasteryController::class, 'masteryFlashcard'])->name('masteryflashcard');
        Route::get('/flashmasterdeck/{id}', [MasteryController::class, 'flashMasterDeck'])->name('flashMasterDeck');
        Route::get('/flashmasterdeck/collection/{id}', [MasteryController::class, 'masteryFlashcardCollection'])->name('masteryflashcardcollection');
        Route::get('/mastery/flashcard/result/{id}', [MasteryController::class, 'masteryResult'])->name('masteryflashcardresult');
        Route::get('/mastery/quiz', [MasteryController::class, 'masteryQuiz'])->name('masteryquiz');
        Route::get('/quizmasterydeck/{id}', [MasteryController::class, 'quizDeck'])->name('quizmasteryDeck');
        Route::get('/quizmasterydeck/collection/{id}', [MasteryController::class, 'masteryQuizCollection'])->name('masteryquizcollection');
        Route::get('/mastery/quiz/result', [MasteryController::class, 'masteryQuizResult'])->name('masteryquizresult');
        Route::get('/mastery/downloadcenter', [MasteryController::class, 'downloadCenter'])->name('downloadcenter');

        Route::post('/subscribe', [SubscribeController::class, 'store'])->name('subscribe');



        Route::get('/subscribe-redirect', [SubscribeController::class, 'subscribeRedirect'])->name('subscribe-redirect')->withoutMiddleware('auth');
    });
});
