@extends('Front.dashboard.layouts.master')

@section('title')
    lesson-flashcard
@endsection

@section('css')
@endsection
@section('level-2')
    <a href="{{ route('front.dashboard.index', $lesson->unit->course->id) }}"> Course
        {{ $lesson->unit->course->title }}</a>
@endsection
@section('level-3')
    <a href="{{ route('front.dashboard.unitLesson', $lesson->unit->id) }}">Unit {{ $lesson->unit->number }}</a>
@endsection
@section('level-4')
    Lesson {{ $lesson->number }}
@endsection
@section('content')
    <section class="Dashboard">
        <div class="conmona serv">
            <h1 class="overpasr">{{ $lesson->unit->course->title }}</h1>
            <div class="form-group">
                <a href="{{ route('front.dashboard.previous', $lesson->id) }}"> <i class="fa-solid fa-chevron-left"></i> </a>
                <a href="{{ route('front.dashboard.next', $lesson->id) }}" style="float: right;"> <i
                        class="fa-solid fa-chevron-right"></i> </a>
                <a>Lesson {{ $lesson->number }} </a>
            </div>

        </div>
        @if (session()->has('message'))
            <div class="alert alert-success">
                {{ session()->get('message') }}
            </div>
        @endif
        <div class="unit-content nn">
            <div class="row justify-content-center mb-5">
                <div class="col-md-12 col-sm-12 col-lg-12 px-0">
                    <section class="postspagrt">
                        <div class="BlogListItem mb-5">
                            <div class="image">
                                @if ($lesson->link)
                                    {!! $lesson->link !!}
                                @elseif($lesson->videos)
                                    {{-- <iframe src="{{ asset($lesson->videos->video) }}" frameborder="0" scrolling="no"
                                        class="RNc8HsWTp1YrU6fAflEq wistia-embed " allowfullscreen=""
                                        mozallowfullscreen="true" webkitallowfullscreen="true" oallowfullscreen="true"
                                        msallowfullscreen="true"></iframe> --}}
                                    <iframe width="560" height="315" src="{{ $lesson->videos->video }}"
                                        frameborder="0" allowfullscreen></iframe>
                                @endif
                            </div>
                            <div class="contentoff">
                                <div class="row justify-content-center mb-5">
                                    <div class="col-md-12 col-sm-8 col-lg-8 px-0">
                                        <div class="details">
                                            <a href="#">

                                                <!-- <div class="rating">
                                                                                        <span class="fas fa-star fa-fw"></span>
                                                                                        <span class="fas fa-star fa-fw"></span>
                                                                                        <span class="fas fa-star fa-fw"></span>
                                                                                        <span class="fas fa-star fa-fw"></span>
                                                                                        <span class="fas fa-star fa-fw"></span>
                                                                                      </div> -->
                                                <h3><a href="">{{ $lesson->unit->course->title }}</a><strong><i
                                                            class="fa-solid fa-chevron-right"></i> Unit
                                                        {{ $lesson->unit->number }}</strong></h3>
                                                <h6>{{ $lesson->title }}</h6>
                                            </a>

                                            <p>{!! $lesson->description !!}</p>
                                        </div>
                                    </div>
                                    <div class="col-md-12 col-sm-4 col-lg-4 px-1">
                                        <section class="Activities__Wrapper-hZAzdt kIjLju">
                                            <div class="stats-container">
                                                <span class="icon undefined"><img
                                                        src="{{ asset('assets/img/svg555(3).png') }}"></span>
                                                <span class="label">flashcard</span>
                                                <span
                                                    class="stat">{{ isset($lesson->flashCards) ? $lesson->flashCards->count() : 0 }}</span>
                                            </div>

                                            <div class="stats-container">
                                                <span class="icon undefined"><img
                                                        src="{{ asset('assets/img/svg555(2).png') }}"></span>
                                                <span class="label">Quiz</span>
                                                <span
                                                    class="stat">{{ isset($lesson->quiz->questions) ? $lesson->quiz->questions->count() . '/' . count($lesson->quiz->questions) : 0 }}</span>
                                                @if ($lesson->flashCards->count() !== 0)
                                                    <a class="btn opser"
                                                        href="{{ route('front.dashboard.lessonpractice', $lesson->id) }}">Practice</a>
                                                @endif
                                                @if ($lesson->quiz)
                                                    @if ($lesson->quiz->questions->count() !== 0)
                                                        <br>
                                                        <a
                                                            href="{{ route('front.dashboard.lessonquiz', $lesson->quiz->id) }}">
                                                            Skip to Quiz</a>
                                                    @endif
                                                @endif
                                            </div>


                                        </section>
                                    </div>
                                </div>
                            </div>
                        </div><!-- BlogListItem -->
                        <div class="kolbutton opp">
                            <ul class="nav nav-tabs nav-tabs-bottom">
                                <li class="active"><a href="#product_desc" data-toggle="tab" class="active">Overview</a>
                                </li>
                                <li><a href="#product_reviews" data-toggle="tab" class="">Audio</a></li>
                                <li><a href="#product_sheet" data-toggle="tab" class="">Notes</a></li>
                                <li><a href="#producheet" data-toggle="tab" class="">FAQ</a></li>
                                <li><a href="#psheet" data-toggle="tab" class="">Reviews</a></li>
                            </ul>
                            <div class="tab-content">
                                <div class="tab-pane active" id="product_desc">
                                    <div class="product-content">
                                        <ul class="disable-scrollbars ">
                                            @foreach ($lesson->flashCards as $flashcard)
                                                <li class="Lynmuf9J_7kHUCdOFb3r ">
                                                    <div class="butoon charttt row">

                                                        <div class="col-md-12 col-sm-4 col-lg-4"><audio class="ml-3"
                                                                controls>
                                                                <source src="{{ asset($flashcard->audios->audio) }}"
                                                                    type="audio/mpeg">
                                                            </audio></div>
                                                        <!-- <button onclick="play()"><img src="{{ asset('assets/img/feathe.png') }}"></button> -->
                                                        <div class="col-md-12 col-sm-4 col-lg-4"><span
                                                                class="english  ">{{ $flashcard->english_word }}</span>
                                                        </div>
                                                        <div class="col-md-12 col-sm-4 col-lg-4"><span
                                                                class="characters">{{ $flashcard->arabic_word }}</span>
                                                        </div>

                                                    </div>
                                                </li>
                                            @endforeach
                                        </ul>
                                    </div>
                                </div><!-- off -->
                                <div class="tab-pane" id="product_reviews">

                                    <div class="product-review">
                                        <div class="product-content">
                                            <ul class="disable-scrollbars ">
                                                <li class="Lynmuf9J_7kHUCdOFb3r ">
                                                    <div class="butoon charttt">
                                                        <!-- <button onclick="play()" id="oneclooo">
                                                                                          <img src="{{ asset('assets/img/Group935.png') }}" class="poseee">
                                                                                          <img src="{{ asset('assets/img/Group2714.png') }}" class="p22ee">
                                                                                        </button> -->
                                                        @isset($lesson->audios->audio)
                                                            <audio controls="">
                                                                <source src="{{ asset($lesson->audios->audio) }}"
                                                                    type="audio/mpeg">
                                                            </audio>
                                                        @endisset
                                                        <div class="poserr122">

                                                        </div>
                                                    </div>
                                                </li>

                                            </ul>
                                        </div>

                                    </div>
                                </div>
                                <div class="tab-pane " id="product_sheet">

                                    <div class="FillParent">
                                        <iframe class="notes-iframe" src="{{ asset($lesson->notes) }}"
                                            title="Lecture Notes Preview"></iframe>
                                    </div>
                                </div><!-- off -->
                                <div class="tab-pane" id="producheet">
                                    <div class="product-content">
                                        <div class="robbbbrobbbb" class=" mb-3" style="    margin-bottom: 15px;">
                                            <form action="{{ route('front.dashboard.lessonfaqstore') }}" method="POST">
                                                @csrf
                                                <div class="form-group mb-3">
                                                    <textarea class="form-control" rows="3" name="question"></textarea>
                                                </div>
                                                <button type="submit" class="btn btn-theme-colored1">Ask</button>
                                                <input type="hidden" name="lesson_id" value="{{ $lesson->id }}">

                                            </form>
                                        </div>
                                        <div class="accordion" id="accordionExample">
                                            @foreach ($lesson->lessonfaqs as $faq)
                                                <div class="accordion-item">
                                                    <h2 class="accordion-header" id="headingOne">
                                                        <button class="accordion-button" type="button"
                                                            data-bs-toggle="collapse" data-bs-target="#collapseOne"
                                                            aria-expanded="true" aria-controls="collapseOne">
                                                            <div class="conteeefaq">
                                                                <div class="author">
                                                                    <img class="rounded"
                                                                        src="{{ asset($faq->user->image) }}">
                                                                    <span>{{ $faq->user->name }}
                                                                        |{{ date($faq->created_at) }}</span>
                                                                </div>
                                                                <p>{{ $faq->question }}</p>

                                                            </div>
                                                        </button>
                                                    </h2>
                                                    <div id="collapseOne" class="accordion-collapse collapse show"
                                                        aria-labelledby="headingOne" data-bs-parent="#accordionExample">
                                                        <div class="accordion-body">
                                                            <div class="contbloss">
                                                                <div class="author">
                                                                    <img class="rounded"
                                                                        src="{{ asset('assets/img/author.png') }}">
                                                                    <span>{{ $faq->answerd_by }}|
                                                                        {{ date($faq->updated_at) }}</span>
                                                                </div>
                                                                <p>{{ $faq->answer }}.</p>
                                                            </div>

                                                        </div>
                                                    </div>
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>
                                </div><!-- off -->
                                <div class="tab-pane" id="psheet">
                                    <div class="product-content">
                                        <div class="specification-wrap table-responsive">
                                            <div class="row mb-5">
                                                <div class="col-md-3">
                                                    <div class="inghttr">
                                                        <h6 class="opoo">Average Rating</h6>
                                                        <div class="mb-3 poser255">
                                                            <h2>{{ round($lesson->lessonReviews->avg('rate')) }}</h2>
                                                            <div class="ratingh">
                                                                @for ($i = 0; $i < 5; $i++)
                                                                    @if ($i < $lesson->lessonReviews->avg('rate'))
                                                                        <i class="fas fa-star"></i>
                                                                    @endif
                                                                @endfor
                                                            </div>
                                                            <li>Rating</li>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-md-9">
                                                    <ul class="list-unstyled">
                                                        <h6 class="opoo">Datials Rating</h6>

                                                        <li class="py-1">

                                                            <a class="row">
                                                                <div class="col-md-3 px-1">

                                                                    <div class="ratingh ">
                                                                        <small class="fas fa-star"></small>
                                                                        <small class="fas fa-star"></small>
                                                                        <small class="fas fa-star"></small>
                                                                        <small class="fas fa-star"></small>
                                                                        <small class="fas fa-star"></small>
                                                                    </div>
                                                                </div>

                                                                <div class="col-md-7 px-1">
                                                                    <div class="progress ml-xl-5" style="height: 5px;">
                                                                        <div class="progress-bar" role="progressbar"
                                                                            style="width:{{$ratingPercentages[5]}}%;"
                                                                            aria-valuemin="0" aria-valuemax="100"></div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-2 text-right px-0">
                                                                    <span
                                                                        class="text-gray-90">{{$ratingPercentages[5]}}%</span>
                                                                </div>
                                                            </a>
                                                        </li>
                                                        <li class="py-1">
                                                            <a class="row">
                                                                <div class="col-md-3 px-1">
                                                                    <div class="ratingh">
                                                                        <small class="fas fa-star"></small>
                                                                        <small class="fas fa-star"></small>
                                                                        <small class="fas fa-star"></small>
                                                                        <small class="fas fa-star"></small>
                                                                        <small class="far fa-star text-muted"></small>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-7 px-1">
                                                                    <div class="progress ml-xl-5" style="height: 5px;">
                                                                        <div class="progress-bar" role="progressbar"
                                                                            style="width:{{$ratingPercentages[4]}}%;"

                                                                            aria-valuemin="0" aria-valuemax="100"></div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-2 text-right px-0">
                                                                    <span
                                                                        class="text-gray-90">{{$ratingPercentages[4]}}%</span>
                                                                </div>
                                                            </a>
                                                        </li>

                                                        <li class="py-1">
                                                            <a class="row" ">
                                                                                                <div class="col-md-3 mb-2 px-1">
                                                                                                    <div class="ratingh">
                                                                                                        <small class="fas fa-star"></small>
                                                                                                        <small class="fas fa-star"></small>
                                                                                                        <small class="fas fa-star"></small>
                                                                                                        <small class="far fa-star text-muted"></small>
                                                                                                        <small class="far fa-star text-muted"></small>
                                                                                                    </div>
                                                                                                </div>
                                                                                                <div class="col-md-7 px-1">
                                                                                                    <div class="progress ml-xl-5" style="height: 5px;">
                                                                                                        <div class="progress-bar" role="progressbar"
                                                                                                            style="width:{{$ratingPercentages[3]}}%;"
                                                                                                            aria-valuemin="0" aria-valuemax="100"></div>
                                                                                                    </div>
                                                                                                </div>
                                                                                                <div class="col-md-2 text-right px-0">
                                                                                                    <span class="text-gray-90">{{ $ratingPercentages[3] }}%</span>
                                                                                                </div>
                                                                                            </a>
                                                                                        </li>

                                                                                        <li class="py-1">
                                                                                            <a class="row"
                                                                                               >
                                                                                                <div class="col-md-3 px-1">
                                                                                                    <div class="ratingh">
                                                                                                        <small class="fas fa-star"></small>
                                                                                                        <small class="fas fa-star"></small>
                                                                                                        <small class="far fa-star text-muted"></small>
                                                                                                        <small class="far fa-star text-muted"></small>
                                                                                                        <small class="far fa-star text-muted"></small>
                                                                                                    </div>
                                                                                                </div>
                                                                                                <div class="col-md-7 px-1">
                                                                                                    <div class="progress ml-xl-5" style="height: 5px;">
                                                                                                        <div class="progress-bar" role="progressbar"
                                                                                                            style="width:{{ $ratingPercentages[2]}}%;"
                                                                                                            aria-valuemin="0" aria-valuemax="100"></div>
                                                                                                    </div>
                                                                                                </div>
                                                                                                <div class="col-md-2 text-right px-0">
                                                                                                    <span class="text-gray-90">{{ $ratingPercentages[2] }}%</span>
                                                                                                </div>
                                                                                            </a>
                                                                                        </li>
                                                                                        <li class="py-1">
                                                                                            <a class="row"
                                                                                                >
                                                                                                <div class="col-md-3 px-1">
                                                                                                    <div class="ratingh">
                                                                                                        <small class="fas fa-star"></small>
                                                                                                        <small class="far fa-star text-muted"></small>
                                                                                                        <small class="far fa-star text-muted"></small>
                                                                                                        <small class="far fa-star text-muted"></small>
                                                                                                        <small class="far fa-star text-muted"></small>
                                                                                                    </div>
                                                                                                </div>
                                                                                                <div class="col-md-7 px-1">
                                                                                                    <div class="progress ml-xl-5" style="height: 5px;">
                                                                                                        <div class="progress-bar" role="progressbar"
                                                                                                            style="width:{{ $ratingPercentages[1] }}%;"
                                                                                                            aria-valuemin="0" aria-valuemax="100"></div>
                                                                                                    </div>
                                                                                                </div>
                                                                                                <div class="col-md-2 px-0 text-right">
                                                                                                    <span class="text-gray-90">{{ $ratingPercentages[1] }}%</span>
                                                                                                </div>
                                                                                            </a>
                                                                                        </li>
                                                                                    </ul>
                                                                                </div>
                                                                            </div>
                                                                            <div class="robbbb">
                                                                                <ul class="review-list comments">

                                                                @foreach ($lesson->lessonReviews as
                                                                $review)
                                                        <li>
                                                            <div class="cont11">

                                                                <img src="{{ asset($review->user->image) }}">
                                                                <div class="opebb">
                                                                    <span
                                                                        class="review-author-name">{{ $review->user->name }}</span>

                                                                    <div class="kokkko">
                                                                        @for ($i = 0; $i < 5; $i++)
                                                                            @if ($i < $review->rate)
                                                                                <i class="fa fa-star rated"></i>
                                                                            @endif
                                                                        @endfor
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <p>{{ $review->comment }}</p>
                                                        </li>
                                                        <br>
                                                        @endforeach
                                                    </ul>



                                                    <form action="{{ route('front.dashboard.lessonreviewstore') }}"
                                                        method="POST">
                                                        @csrf
                                                        <input type="hidden" name="lesson_id" id="lesson_id"
                                                            value="{{ $lesson->id }}">
                                                        <div class="row">
                                                            <div class="feedback d-flex col-4" data-bs-toggle="collapse"
                                                                href="#collapseExample" role="button"
                                                                aria-expanded="false" aria-controls="collapseExample">
                                                                <div class="rating">
                                                                    <input type="radio" name="rating" value="5"
                                                                        id="rating-5">
                                                                    <label for="rating-5"></label>
                                                                    <input type="radio" name="rating" value="4"
                                                                        id="rating-4">
                                                                    <label for="rating-4"></label>
                                                                    <input type="radio" name="rating" value="3"
                                                                        id="rating-3">
                                                                    <label for="rating-3"></label>
                                                                    <input type="radio" name="rating" value="2"
                                                                        id="rating-2">
                                                                    <label for="rating-2"></label>
                                                                    <input type="radio" name="rating" value="1"
                                                                        id="rating-1">
                                                                    <label for="rating-1"></label>
                                                                    <div class="emoji-wrapper">
                                                                        <div class="emoji">
                                                                            <svg class="rating-0"
                                                                                xmlns="http://www.w3.org/2000/svg"
                                                                                viewBox="0 0 512 512">
                                                                                <circle cx="256" cy="256"
                                                                                    r="256" fill="#ffd93b" />
                                                                                <path
                                                                                    d="M512 256c0 141.44-114.64 256-256 256-80.48 0-152.32-37.12-199.28-95.28 43.92 35.52 99.84 56.72 160.72 56.72 141.36 0 256-114.56 256-256 0-60.88-21.2-116.8-56.72-160.72C474.8 103.68 512 175.52 512 256z"
                                                                                    fill="#f4c534" />
                                                                                <ellipse
                                                                                    transform="scale(-1) rotate(31.21 715.433 -595.455)"
                                                                                    cx="166.318" cy="199.829"
                                                                                    rx="56.146" ry="56.13"
                                                                                    fill="#fff" />
                                                                                <ellipse
                                                                                    transform="rotate(-148.804 180.87 175.82)"
                                                                                    cx="180.871" cy="175.822"
                                                                                    rx="28.048" ry="28.08"
                                                                                    fill="#3e4347" />
                                                                                <ellipse
                                                                                    transform="rotate(-113.778 194.434 165.995)"
                                                                                    cx="194.433" cy="165.993"
                                                                                    rx="8.016" ry="5.296"
                                                                                    fill="#5a5f63" />
                                                                                <ellipse
                                                                                    transform="scale(-1) rotate(31.21 715.397 -1237.664)"
                                                                                    cx="345.695" cy="199.819"
                                                                                    rx="56.146" ry="56.13"
                                                                                    fill="#fff" />
                                                                                <ellipse
                                                                                    transform="rotate(-148.804 360.25 175.837)"
                                                                                    cx="360.252" cy="175.84"
                                                                                    rx="28.048" ry="28.08"
                                                                                    fill="#3e4347" />
                                                                                <ellipse
                                                                                    transform="scale(-1) rotate(66.227 254.508 -573.138)"
                                                                                    cx="373.794" cy="165.987"
                                                                                    rx="8.016" ry="5.296"
                                                                                    fill="#5a5f63" />
                                                                                <path
                                                                                    d="M370.56 344.4c0 7.696-6.224 13.92-13.92 13.92H155.36c-7.616 0-13.92-6.224-13.92-13.92s6.304-13.92 13.92-13.92h201.296c7.696.016 13.904 6.224 13.904 13.92z"
                                                                                    fill="#3e4347" />
                                                                            </svg>
                                                                            <svg class="rating-1"
                                                                                xmlns="http://www.w3.org/2000/svg"
                                                                                viewBox="0 0 512 512">
                                                                                <circle cx="256" cy="256"
                                                                                    r="256" fill="#ffd93b" />
                                                                                <path
                                                                                    d="M512 256A256 256 0 0 1 56.7 416.7a256 256 0 0 0 360-360c58.1 47 95.3 118.8 95.3 199.3z"
                                                                                    fill="#f4c534" />
                                                                                <path
                                                                                    d="M328.4 428a92.8 92.8 0 0 0-145-.1 6.8 6.8 0 0 1-12-5.8 86.6 86.6 0 0 1 84.5-69 86.6 86.6 0 0 1 84.7 69.8c1.3 6.9-7.7 10.6-12.2 5.1z"
                                                                                    fill="#3e4347" />
                                                                                <path
                                                                                    d="M269.2 222.3c5.3 62.8 52 113.9 104.8 113.9 52.3 0 90.8-51.1 85.6-113.9-2-25-10.8-47.9-23.7-66.7-4.1-6.1-12.2-8-18.5-4.2a111.8 111.8 0 0 1-60.1 16.2c-22.8 0-42.1-5.6-57.8-14.8-6.8-4-15.4-1.5-18.9 5.4-9 18.2-13.2 40.3-11.4 64.1z"
                                                                                    fill="#f4c534" />
                                                                                <path
                                                                                    d="M357 189.5c25.8 0 47-7.1 63.7-18.7 10 14.6 17 32.1 18.7 51.6 4 49.6-26.1 89.7-67.5 89.7-41.6 0-78.4-40.1-82.5-89.7A95 95 0 0 1 298 174c16 9.7 35.6 15.5 59 15.5z"
                                                                                    fill="#fff" />
                                                                                <path
                                                                                    d="M396.2 246.1a38.5 38.5 0 0 1-38.7 38.6 38.5 38.5 0 0 1-38.6-38.6 38.6 38.6 0 1 1 77.3 0z"
                                                                                    fill="#3e4347" />
                                                                                <path
                                                                                    d="M380.4 241.1c-3.2 3.2-9.9 1.7-14.9-3.2-4.8-4.8-6.2-11.5-3-14.7 3.3-3.4 10-2 14.9 2.9 4.9 5 6.4 11.7 3 15z"
                                                                                    fill="#fff" />
                                                                                <path
                                                                                    d="M242.8 222.3c-5.3 62.8-52 113.9-104.8 113.9-52.3 0-90.8-51.1-85.6-113.9 2-25 10.8-47.9 23.7-66.7 4.1-6.1 12.2-8 18.5-4.2 16.2 10.1 36.2 16.2 60.1 16.2 22.8 0 42.1-5.6 57.8-14.8 6.8-4 15.4-1.5 18.9 5.4 9 18.2 13.2 40.3 11.4 64.1z"
                                                                                    fill="#f4c534" />
                                                                                <path
                                                                                    d="M155 189.5c-25.8 0-47-7.1-63.7-18.7-10 14.6-17 32.1-18.7 51.6-4 49.6 26.1 89.7 67.5 89.7 41.6 0 78.4-40.1 82.5-89.7A95 95 0 0 0 214 174c-16 9.7-35.6 15.5-59 15.5z"
                                                                                    fill="#fff" />
                                                                                <path
                                                                                    d="M115.8 246.1a38.5 38.5 0 0 0 38.7 38.6 38.5 38.5 0 0 0 38.6-38.6 38.6 38.6 0 1 0-77.3 0z"
                                                                                    fill="#3e4347" />
                                                                                <path
                                                                                    d="M131.6 241.1c3.2 3.2 9.9 1.7 14.9-3.2 4.8-4.8 6.2-11.5 3-14.7-3.3-3.4-10-2-14.9 2.9-4.9 5-6.4 11.7-3 15z"
                                                                                    fill="#fff" />
                                                                            </svg>
                                                                            <svg class="rating-2"
                                                                                xmlns="http://www.w3.org/2000/svg"
                                                                                viewBox="0 0 512 512">
                                                                                <circle cx="256" cy="256"
                                                                                    r="256" fill="#ffd93b" />
                                                                                <path
                                                                                    d="M512 256A256 256 0 0 1 56.7 416.7a256 256 0 0 0 360-360c58.1 47 95.3 118.8 95.3 199.3z"
                                                                                    fill="#f4c534" />
                                                                                <path
                                                                                    d="M336.6 403.2c-6.5 8-16 10-25.5 5.2a117.6 117.6 0 0 0-110.2 0c-9.4 4.9-19 3.3-25.6-4.6-6.5-7.7-4.7-21.1 8.4-28 45.1-24 99.5-24 144.6 0 13 7 14.8 19.7 8.3 27.4z"
                                                                                    fill="#3e4347" />
                                                                                <path
                                                                                    d="M276.6 244.3a79.3 79.3 0 1 1 158.8 0 79.5 79.5 0 1 1-158.8 0z"
                                                                                    fill="#fff" />
                                                                                <circle cx="340" cy="260.4"
                                                                                    r="36.2" fill="#3e4347" />
                                                                                <g fill="#fff">
                                                                                    <ellipse
                                                                                        transform="rotate(-135 326.4 246.6)"
                                                                                        cx="326.4" cy="246.6"
                                                                                        rx="6.5" ry="10" />
                                                                                    <path
                                                                                        d="M231.9 244.3a79.3 79.3 0 1 0-158.8 0 79.5 79.5 0 1 0 158.8 0z" />
                                                                                </g>
                                                                                <circle cx="168.5" cy="260.4"
                                                                                    r="36.2" fill="#3e4347" />
                                                                                <ellipse
                                                                                    transform="rotate(-135 182.1 246.7)"
                                                                                    cx="182.1" cy="246.7"
                                                                                    rx="10" ry="6.5"
                                                                                    fill="#fff" />
                                                                            </svg>
                                                                            <svg class="rating-3"
                                                                                xmlns="http://www.w3.org/2000/svg"
                                                                                viewBox="0 0 512 512">
                                                                                <circle cx="256" cy="256"
                                                                                    r="256" fill="#ffd93b" />
                                                                                <path
                                                                                    d="M407.7 352.8a163.9 163.9 0 0 1-303.5 0c-2.3-5.5 1.5-12 7.5-13.2a780.8 780.8 0 0 1 288.4 0c6 1.2 9.9 7.7 7.6 13.2z"
                                                                                    fill="#3e4347" />
                                                                                <path
                                                                                    d="M512 256A256 256 0 0 1 56.7 416.7a256 256 0 0 0 360-360c58.1 47 95.3 118.8 95.3 199.3z"
                                                                                    fill="#f4c534" />
                                                                                <g fill="#fff">
                                                                                    <path
                                                                                        d="M115.3 339c18.2 29.6 75.1 32.8 143.1 32.8 67.1 0 124.2-3.2 143.2-31.6l-1.5-.6a780.6 780.6 0 0 0-284.8-.6z" />
                                                                                    <ellipse cx="356.4" cy="205.3"
                                                                                        rx="81.1" ry="81" />
                                                                                </g>
                                                                                <ellipse cx="356.4" cy="205.3"
                                                                                    rx="44.2" ry="44.2"
                                                                                    fill="#3e4347" />
                                                                                <g fill="#fff">
                                                                                    <ellipse
                                                                                        transform="scale(-1) rotate(45 454 -906)"
                                                                                        cx="375.3" cy="188.1"
                                                                                        rx="12" ry="8.1" />
                                                                                    <ellipse cx="155.6" cy="205.3"
                                                                                        rx="81.1" ry="81" />
                                                                                </g>
                                                                                <ellipse cx="155.6" cy="205.3"
                                                                                    rx="44.2" ry="44.2"
                                                                                    fill="#3e4347" />
                                                                                <ellipse
                                                                                    transform="scale(-1) rotate(45 454 -421.3)"
                                                                                    cx="174.5" cy="188"
                                                                                    rx="12" ry="8.1"
                                                                                    fill="#fff" />
                                                                            </svg>
                                                                            <svg class="rating-4"
                                                                                xmlns="http://www.w3.org/2000/svg"
                                                                                viewBox="0 0 512 512">
                                                                                <circle cx="256" cy="256"
                                                                                    r="256" fill="#ffd93b" />
                                                                                <path
                                                                                    d="M512 256A256 256 0 0 1 56.7 416.7a256 256 0 0 0 360-360c58.1 47 95.3 118.8 95.3 199.3z"
                                                                                    fill="#f4c534" />
                                                                                <path
                                                                                    d="M232.3 201.3c0 49.2-74.3 94.2-74.3 94.2s-74.4-45-74.4-94.2a38 38 0 0 1 74.4-11.1 38 38 0 0 1 74.3 11.1z"
                                                                                    fill="#e24b4b" />
                                                                                <path
                                                                                    d="M96.1 173.3a37.7 37.7 0 0 0-12.4 28c0 49.2 74.3 94.2 74.3 94.2C80.2 229.8 95.6 175.2 96 173.3z"
                                                                                    fill="#d03f3f" />
                                                                                <path
                                                                                    d="M215.2 200c-3.6 3-9.8 1-13.8-4.1-4.2-5.2-4.6-11.5-1.2-14.1 3.6-2.8 9.7-.7 13.9 4.4 4 5.2 4.6 11.4 1.1 13.8z"
                                                                                    fill="#fff" />
                                                                                <path
                                                                                    d="M428.4 201.3c0 49.2-74.4 94.2-74.4 94.2s-74.3-45-74.3-94.2a38 38 0 0 1 74.4-11.1 38 38 0 0 1 74.3 11.1z"
                                                                                    fill="#e24b4b" />
                                                                                <path
                                                                                    d="M292.2 173.3a37.7 37.7 0 0 0-12.4 28c0 49.2 74.3 94.2 74.3 94.2-77.8-65.7-62.4-120.3-61.9-122.2z"
                                                                                    fill="#d03f3f" />
                                                                                <path
                                                                                    d="M411.3 200c-3.6 3-9.8 1-13.8-4.1-4.2-5.2-4.6-11.5-1.2-14.1 3.6-2.8 9.7-.7 13.9 4.4 4 5.2 4.6 11.4 1.1 13.8z"
                                                                                    fill="#fff" />
                                                                                <path
                                                                                    d="M381.7 374.1c-30.2 35.9-75.3 64.4-125.7 64.4s-95.4-28.5-125.8-64.2a17.6 17.6 0 0 1 16.5-28.7 627.7 627.7 0 0 0 218.7-.1c16.2-2.7 27 16.1 16.3 28.6z"
                                                                                    fill="#3e4347" />
                                                                                <path
                                                                                    d="M256 438.5c25.7 0 50-7.5 71.7-19.5-9-33.7-40.7-43.3-62.6-31.7-29.7 15.8-62.8-4.7-75.6 34.3 20.3 10.4 42.8 17 66.5 17z"
                                                                                    fill="#e24b4b" />
                                                                            </svg>
                                                                            <svg class="rating-5"
                                                                                xmlns="http://www.w3.org/2000/svg"
                                                                                viewBox="0 0 512 512">
                                                                                <g fill="#ffd93b">
                                                                                    <circle cx="256" cy="256"
                                                                                        r="256" />
                                                                                    <path
                                                                                        d="M512 256A256 256 0 0 1 56.8 416.7a256 256 0 0 0 360-360c58 47 95.2 118.8 95.2 199.3z" />
                                                                                </g>
                                                                                <path
                                                                                    d="M512 99.4v165.1c0 11-8.9 19.9-19.7 19.9h-187c-13 0-23.5-10.5-23.5-23.5v-21.3c0-12.9-8.9-24.8-21.6-26.7-16.2-2.5-30 10-30 25.5V261c0 13-10.5 23.5-23.5 23.5h-187A19.7 19.7 0 0 1 0 264.7V99.4c0-10.9 8.8-19.7 19.7-19.7h472.6c10.8 0 19.7 8.7 19.7 19.7z"
                                                                                    fill="#e9eff4" />
                                                                                <path
                                                                                    d="M204.6 138v88.2a23 23 0 0 1-23 23H58.2a23 23 0 0 1-23-23v-88.3a23 23 0 0 1 23-23h123.4a23 23 0 0 1 23 23z"
                                                                                    fill="#45cbea" />
                                                                                <path
                                                                                    d="M476.9 138v88.2a23 23 0 0 1-23 23H330.3a23 23 0 0 1-23-23v-88.3a23 23 0 0 1 23-23h123.4a23 23 0 0 1 23 23z"
                                                                                    fill="#e84d88" />
                                                                                <g fill="#38c0dc">
                                                                                    <path
                                                                                        d="M95.2 114.9l-60 60v15.2l75.2-75.2zM123.3 114.9L35.1 203v23.2c0 1.8.3 3.7.7 5.4l116.8-116.7h-29.3z" />
                                                                                </g>
                                                                                <g fill="#d23f77">
                                                                                    <path
                                                                                        d="M373.3 114.9l-66 66V196l81.3-81.2zM401.5 114.9l-94.1 94v17.3c0 3.5.8 6.8 2.2 9.8l121.1-121.1h-29.2z" />
                                                                                </g>
                                                                                <path
                                                                                    d="M329.5 395.2c0 44.7-33 81-73.4 81-40.7 0-73.5-36.3-73.5-81s32.8-81 73.5-81c40.5 0 73.4 36.3 73.4 81z"
                                                                                    fill="#3e4347" />
                                                                                <path
                                                                                    d="M256 476.2a70 70 0 0 0 53.3-25.5 34.6 34.6 0 0 0-58-25 34.4 34.4 0 0 0-47.8 26 69.9 69.9 0 0 0 52.6 24.5z"
                                                                                    fill="#e24b4b" />
                                                                                <path
                                                                                    d="M290.3 434.8c-1 3.4-5.8 5.2-11 3.9s-8.4-5.1-7.4-8.7c.8-3.3 5.7-5 10.7-3.8 5.1 1.4 8.5 5.3 7.7 8.6z"
                                                                                    fill="#fff" opacity=".2" />
                                                                            </svg>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="form-group  collapse col-8" id="collapseExample">

                                                                <textarea class="form-control comment" name ='comment'rows="3" placeholder="Write Your Fedack Here ..."></textarea>
                                                            </div>
                                                        </div>
                                                        <button type="submit" id="submit-button"
                                                            class="btn btn-theme-colored1">Send Fedback</button>
                                                    </form>



                                                    {{-- @if ($review->user_id !== auth()->user()->id)
                        <div class="form-group mb-3">
                           @csrf
                          <textarea class="form-control comment" rows="3" placeholder="make fed back here"></textarea>
                        </div>
                        <button type="submit"  data-lesson="{{ $lesson->id }}"class="btn btn-theme-colored1  save-comment">submit</button>
                      @endif --}}
                                                    <!-- End Form -->
                                                </div>
                                            </div>
                                        </div>
                                    </div><!-- off -->
                                </div><!-- tab-content -->
                            </div><!-- kolbutton -->

                    </section><!-- postspagrt -->
                </div><!-- col-md-12 col-sm-7 col-lg-7 px-0 -->
            </div><!-- row -->


        </div><!-- unit-content -->



    </section><!-- postspagrt -->
@endsection

@section('js')
    {{-- <script>
        $(".save-comment").on('click', function() {
            var comment = $(".comment").val();
            var lesson_id = $(this).data('lesson');
            var vm = $(this);
            // Run Ajax
            $.ajax({
                url: "{{ route('front.dashboard.lessonreviewstore') }}",
                type: "post",
                dataType: 'json',
                data: {
                    comment: comment,
                    lesson_id: lesson_id,
                    _token: "{{ csrf_token() }}"
                },
                beforeSend: function() {
                    vm.text('Saving...').addClass('disabled');
                },
                success: function(res) {

                    var _html = '<li>\
                                                                      <div class="cont11"> \
                                                                      <img src="http://127.0.0.1:8000/' + res.image + '">\
                                                                        <div class="opebb">\
                                                                          <span class="review-author-name">' + res.name + '</span>\
                                                                          <div class="kokkko"> \
                                                                            <i class="fa fa-star rated"></i>\
                                                                            <i class="fa fa-star rated"></i>\
                                                                            <i class="fa fa-star rated"></i>\
                                                                            <i class="fa fa-star rated"></i>\
                                                                          </div>\
                                                                        </div>\
                                                                      </div>\
                                                                      <p>' + comment + '</p>\
                                                                    </li>'

                    if (res.bool == true) {
                        $(".comments").prepend(_html);
                        $(".comment").val('');
                        $(".comment-count").text($('blockquote').length);
                        $(".no-comments").hide();
                    }
                    vm.text('Save').removeClass('disabled');
                }
            });
        });
    </script> --}}
    <script type="text/javascript">
        $(function() {
            $('.chart').easyPieChart({
                size: 90,
                barColor: "#70C491E5",
                scaleLength: 0,
                lineWidth: 10,
                trackColor: "#FF7648",
                lineCap: "circle",
                animate: 2000,
            });
        });
    </script>
    <script>
        $(function() {
            $(".nn").show();
            $(".hh").hide();
            $("#contributor_type").click(function() {
                var id = $('#contributor_type').val();
                if (id == 1) {
                    $(".hh").hide();
                    $(".nn").show();
                } else if (id == 2) {
                    $(".hh").show();
                    $(".nn").hide();
                }
            });
        });
    </script>
    <!--  -->
    @include('sweetalert::alert')
@endsection
