<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <link rel="icon" href="">
    <title>{{ $guide->title }}</title>

    <!-- <script src="{{ asset('assets/mona/assets/mona/assets/js/vendor/vendor.min.js') }}"></script> -->

    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"
        integrity="sha384-DfXdz2htPH0lsSSs5nCTpuj/zy4C+OGpamoFVy38MVBnE+IbbVYUew+OrCXaRkfj" crossorigin="anonymous">
    </script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.3.1/jquery.min.js" charset="utf-8"></script>

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.1/dist/umd/popper.min.js"
        integrity="sha384-9/reFTGAW83EW2RDu2S0VKaIzap3H66lZH81PoYlFhbGU+6BZp6G7niu735Sk7lN" crossorigin="anonymous">
    </script>
    <script src="{{ asset('assets/mona/assets/js/jquery.slimscroll.js') }}"></script>

    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/bootstrap.min.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/slick.css') }}" />
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/slick-theme.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/jquery-ui.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/fontawesome/css/all.min.css') }}">

    <link rel="stylesheet" type="text/css" href="{{ asset('assets/mona/css2/owl.theme.default.min.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/mona/css2/owl.carousel.min.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/mona/assets/css/main.css') }}">

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.0/css/all.min.css"
        integrity="sha512-xh6O/CkQoPOWDdYTDqeRdPCVd1SpvCA9XXcUnZS2FmJNp1coAFzvtCN9BmamE+4aHK8yyUHUSCcJHgXloTyT2A=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/mona/assets/css/candly-style.css') }}">

</head>

<body>
    <div class="guides-style guides-account-style">
        <header class="green-header ">
            <div class='container w-80'>
                <div class="row">
                    <!-- As a link -->
                    <nav class="navbar navbar-light pt-3">
                        <a class="navbar-brand" href="{{ route('front.index') }}">
                            <img src="{{ asset($setting->logo) }}" class="logo-img"></a>
                        <div class='mr-auto'>
                            <a href="facebook.com" class="text-light">Home</a>
                        </div>
                    </nav>
                    <div class="pt-3 pb-3 text-center"> </div>
                    <div class="pb-3">
                        <form class="search-button-container">
                            <input class="form-control mr-sm-2 search-button" type="search" placeholder="Search"
                                aria-label="Search">
                            <div class="search-button-fa">
                                <i class="fa fa-search"></i>
                            </div>
                        </form>
                    </div>
                    <div class="mb-4 mt-3">
                        <a href="{{ route('front.dashboard.guides') }}" class="text-light">Homepage -></a>
                        <a href="{{ route('front.dashboard.guidesdetails', $guide->guideSubCategory->id) }}"
                            class="text-light">
                            <span class="text-light"> {{ $guide->guideSubCategory->title }} -></span>
                        </a>
                        <span class="text-light"> {{ $guide->title }}</span>
                    </div>
                </div>
            </div>
        </header>

        <div class="container boxes-container mb-5 card-body-inline container-account">
            <div class="row w-80">
                <div class='mt-5 mb-5'>
                    <h2 class='fs-2 account-title'>{{ $guide->title }}</h2>
                    <p class="fs-4 account-text">{{ $guide->description }}</p>
                </div>
                <div class="col-lg-3">
                    <div class="img-section-container">
                        <img class="author-image"
                            src="https://ucarecdn.com/af1bd025-0651-4296-8c8c-83cf5a549a82/-/scale_crop/100x100/"
                            alt="">
                        <div class="text-part">
                            <p>Written by {{ $guide->created_by }}</p>
                            <p>Updated {{ $guide->written_at }}</p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-9"></div>
                @foreach ($guide->guideDetails as $detail)
                    <div class="col-lg-12 guide-details">
                        <h2 class='fs-2 mt-5'>{{ $detail->title }}</h2>
                        <p class="fs-4 mt-4"> {{ $detail->description }}</p>
                        @if ($detail->images->count() > 0)
                            @foreach ($detail->images as $image)
                                <img src="{{ asset($image->image) }}" class="mt-4 mb-4 img-responsive">
                            @endforeach
                        @endif
                        <a class="ql-link" href="{{ $detail->link }}" rel="noopener noreferrer" target="_blank">Course
                            Index PDF</a>

                        <!-- <div class="col-lg-12 mt-5 mb-3">
                        <div id="emoji-div"></div>
                    </div> -->
                    </div>
                @endforeach
            </div>
        </div>
    </div>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
    <script src="{{ asset('assets/js/emoji.js') }}"></script>
    <!--                                            -->
    <!--                                            -->
    <!--<script src="js/jquery.min.js"></script>-->
    <script>
        $(function() {
            //var emojis = ['&#x1F620;'];
            //$("#emoji-div").emoji({ value: 4 });
            $("#emoji-div").emoji();
        });
    </script>



</body>

</html>
