@extends('Admin.layouts.master')

@section('title')
    Edit Uploded files
@endsection
@section('level-2')
    <a href="{{route('admin.uplodedfile.index')}}">Uploded files</a>
@endsection
@section('level-3')
    Edit
@endsection
@section('title', 'Edit download attachement')

@section('css')


@endsection

@section('content')
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <!--begin::Card-->
                <div class="card card-custom gutter-b example example-compact">
                    <div class="card-header">
                        <h3 class="card-title">Edit download attachement</h3>
                        <div class="card-toolbar">
                            <div class="example-tools justify-content-center">

                            </div>
                        </div>
                    </div>
                    <!--begin::Form-->
                    <form method="post" action="{{ route('admin.uplodedfile.update') }}" enctype="multipart/form-data">
                        @csrf
                        @method ('put')

                        <input type="hidden" name="id" value="{{ $uplodedfile->id }}">
                        <div class="card-body">
                            <div class="form-group mb-8">
                                <div class="form-group">
                                    <label for="exampleSelect1">downloadattachement
                                        <span class="text-danger">*</span></label>
                                    <select
                                        class="form-control  @error('downloadattachement_id') is-invalid fparsley-error parsley-error @enderror"
                                        id="exampleSelect1" name="downloadattachement_id">
                                        <option value="">choose downloadattachement</option>
                                        @foreach ($downloadattachements as $downloadattachement)
                                            <option value="{{ $downloadattachement->id }}"
                                                {{ old('downloadattachement_id') == $downloadattachement->id || $uplodedfile->download_attachement_id == $downloadattachement->id ? 'selected' : '' }}>
                                                {{ $downloadattachement->title }}</option>
                                        @endforeach
                                    </select>
                                    @error('downloadattachement_id')
                                        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                            role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label>Title
                                        <span class="text-danger">*</span></label>
                                    <input type="text"
                                        class="form-control @error('title') is-invalid fparsley-error parsley-error @enderror"
                                        placeholder="Title" name="title"
                                        value="{{ old('title', $uplodedfile->title ?? '') }}" />
                                    @error('title')
                                        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                            role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <label for="exampleTextarea">File </label>
                                    <input type="file"
                                        class="form-control @error('link') is-invalid fparsley-error parsley-error @enderror"
                                        placeholder="link" name="link"
                                        value="{{ old('link', $uplodedfile->link ?? '') }}">
                                    @error('link')
                                        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                            role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>


                            </div>

                            <div class="card-footer">
                                <button type="submit" class="btn btn-primary mr-2">Submit</button>

                            </div>
                        </div>
                    </form><!--end::Form-->
                </div>


                <!--end::Card-->
            </div>
        </div>
    </div><!--end::Container-->

@endsection


@section('js')


@endsection
