@extends('Admin.layouts.master')

@section('title')
    Edit setting
@endsection
@section('level-2')
    Setting
@endsection
@section('page_title', 'Edit setting')

@section('css')


@endsection

@section('content')
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <!--begin::Card-->
                <div class="card card-custom gutter-b example example-compact">
                    <div class="card-header">
                        <h3 class="card-title">Edit Setting</h3>
                        <div class="card-toolbar">
                            <div class="example-tools justify-content-center">

                            </div>
                        </div>
                    </div>
                    <!--begin::Form-->
                    <form method="post" action="{{ route('admin.setting.update') }}" enctype="multipart/form-data">
                        @csrf
                        @method ('PUT')
                        <div class="card-body">
                            <div class="form-group mb-8">
                                <input type="hidden" name="id" value="{{ $setting->id }}">

                                <div class="row g-3">
                                    <div class="col-md-8">
                                        <div class="form-group">
                                            <label>logo
                                                <span class="text-danger">*</span></label>
                                            <input type="file"
                                                class="form-control @error('logo') is-invalid fparsley-error parsley-error @enderror"
                                                placeholder="logo" name="logo"
                                                value="{{ old('logo', $setting->logo) }}" />
                                            @error('logo')
                                                <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                                    role="alert">
                                                    <p>{{ $message }}</p>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <img style="width:100px;" src="{{ asset($setting->logo) }}">
                                    </div>


                                </div>


                                <div class="row g-3">
                                    <div class="col-md-8">
                                        <div class="form-group">
                                            <label>dash logo
                                                <span class="text-danger">*</span></label>
                                            <input type="file"
                                                class="form-control @error('dash_logo') is-invalid fparsley-error parsley-error @enderror"
                                                placeholder="dash logo" name="dash_logo"
                                                value="{{ old('dash_logo', $setting->dash_logo) }}" />
                                            @error('dash_logo')
                                                <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                                    role="alert">
                                                    <p>{{ $message }}</p>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <img style="width:100px;" src="{{ asset($setting->dash_logo) }}">
                                    </div>


                                </div>

                                <div class="row g-3">
                                    <div class="col-md-6">
                                        <div class="form-group">

                                            <input type="checkbox" id="level_check"
                                                class="form-check-input @error('level_check') is-invalid fparsley-error parsley-error @enderror"
                                                name="level_check" @if (old('level_check', $setting->level_check)) checked @endif />
                                            <label for="level_check" class="form-check-label">Check Your Level
                                                <span class="text-danger">*</span></label>
                                            @error('level_check')
                                                <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                                    role="alert">
                                                    <p>{{ $message }}</p>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>facebook
                                                <span class="text-danger">*</span></label>
                                            <input type="text"
                                                class="form-control @error('facebook') is-invalid fparsley-error parsley-error @enderror"
                                                placeholder="facebook" name="facebook"
                                                value="{{ old('facebook', $setting->facebook) }}" />
                                            @error('facebook')
                                                <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                                    role="alert">
                                                    <p>{{ $message }}</p>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>twitter
                                                <span class="text-danger">*</span></label>
                                            <input type="text"
                                                class="form-control @error('twitter') is-invalid fparsley-error parsley-error @enderror"
                                                placeholder="twitter" name="twitter"
                                                value="{{ old('twitter', $setting->twitter) }}" />
                                            @error('twitter')
                                                <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                                    role="alert">
                                                    <p>{{ $message }}</p>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>instagram
                                                <span class="text-danger">*</span></label>
                                            <input type="text"
                                                class="form-control @error('instagram') is-invalid fparsley-error parsley-error @enderror"
                                                placeholder="instagram" name="instagram"
                                                value="{{ old('instagram', $setting->instagram) }}" />
                                            @error('instagram')
                                                <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                                    role="alert">
                                                    <p>{{ $message }}</p>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>linkedin
                                                <span class="text-danger">*</span></label>
                                            <input type="text"
                                                class="form-control @error('linkedin') is-invalid fparsley-error parsley-error @enderror"
                                                placeholder="linkedin" name="linkedin"
                                                value="{{ old('linkedin', $setting->linkedin) }}" />
                                            @error('linkedin')
                                                <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                                    role="alert">
                                                    <p>{{ $message }}</p>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>youtube
                                                <span class="text-danger">*</span></label>
                                            <input type="text"
                                                class="form-control @error('youtube') is-invalid fparsley-error parsley-error @enderror"
                                                placeholder="youtube" name="youtube"
                                                value="{{ old('youtube', $setting->youtube) }}" />
                                            @error('youtube')
                                                <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                                    role="alert">
                                                    <p>{{ $message }}</p>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Test Count
                                                <span class="text-danger">*</span></label>
                                            <input type="text"
                                                class="form-control @error('test_count') is-invalid fparsley-error parsley-error @enderror"
                                                placeholder="test count" name="test_count"
                                                value="{{ old('test_count', $setting->test_count) }}" />
                                            @error('test_count')
                                                <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                                    role="alert">
                                                    <p>{{ $message }}</p>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>

                                </div>

                                <div class="form-group">
                                    <label>email
                                        <span class="text-danger">*</span></label>
                                    <input type="email"
                                        class="form-control @error('email') is-invalid fparsley-error parsley-error @enderror"
                                        placeholder="email" name="email"
                                        value="{{ old('email', $setting->email) }}" />
                                    @error('email')
                                        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                            role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <label>phone
                                        <span class="text-danger">*</span></label>
                                    <input type="text"
                                        class="form-control @error('phone') is-invalid fparsley-error parsley-error @enderror"
                                        placeholder="phone" name="phone"
                                        value="{{ old('phone', $setting->phone) }}" />
                                    @error('phone')
                                        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                            role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label>address
                                        <span class="text-danger">*</span></label>
                                    <input type="text"
                                        class="form-control @error('address') is-invalid fparsley-error parsley-error @enderror"
                                        placeholder="address" name="address"
                                        value="{{ old('address', $setting->address) }}" />
                                    @error('address')
                                        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                            role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <label for="exampleTextarea">policy</label>
                                    <textarea id="kt-ckeditor-1"
                                        class="form-control ckeditor @error('policy') is-invalid fparsley-error parsley-error @enderror"
                                        placeholder="policy" name="policy">{{ old('policy', $setting->policy) }}</textarea>
                                    @error('policy')
                                        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                            role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="exampleTextarea">terms</label>
                                    <textarea id="kt-ckeditor-2" class="form-control @error('terms') is-invalid fparsley-error parsley-error @enderror"
                                        placeholder="terms" name="terms">{{ old('terms', $setting->terms) }}</textarea>
                                    @error('terms')
                                        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                            role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="card-footer">
                                <button type="submit" class="btn btn-primary mr-2">Submit</button>

                            </div>
                        </div>
                    </form><!--end::Form-->
                </div>


                <!--end::Card-->
            </div>
        </div>
    </div><!--end::Container-->

@endsection


@section('js')
    <script src="{{ asset('assets/Admin/assets/plugins/custom/ckeditor/ckeditor-classic.bundle.js') }}"></script>
    <script src="{{ asset('assets/Admin/assets/js/pages/crud/forms/editors/ckeditor-classic.js') }}"></script>
@endsection
