@extends('Admin.layouts.master')

@section('title')
    Lesson Review
@endsection
@section('page_title', 'Lesson Review')
@section('css')

    <!--begin::Page Vendors Styles(used by this page)-->
    <link href="{{ asset('assets/Admin/assets/plugins/custom/datatables/datatables.bundle.css') }}" rel="stylesheet"
        type="text/css" />
    <!--end::Page Vendors Styles-->
@endsection

@section('content')
    <div class="d-flex flex-column-fluid">
        <!--begin::Container-->
        <div class="container">

            <!--begin::Card-->
            <div class="card card-custom gutter-b">
                <div class="card-header flex-wrap border-0 pt-6 pb-0">
                    <div class="card-title">
                        <h3 class="card-label">Lesson Review

                    </div>
                    <div class="card-toolbar">
                        @if (auth()->guard('admin')->user()->hasPermission('Add'))
                        <!--begin::Button-->
                        <!-- <a href="{{ route('admin.lesson.create') }}" class="btn btn-primary font-weight-bolder"> -->
                        <span class="svg-icon svg-icon-md">
                            <!--begin::Svg Icon | path:assets/media/svg/icons/Design/Flatten.svg-->
                            <!-- <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
                            <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                            <rect x="0" y="0" width="24" height="24" />
                            <circle fill="#000000" cx="9" cy="15" r="6" />
                            <path d="M8.8012943,7.00241953 C9.83837775,5.20768121 11.7781543,4 14,4 C17.3137085,4 20,6.6862915 20,10 C20,12.2218457 18.7923188,14.1616223 16.9975805,15.1987057 C16.9991904,15.1326658 17,15.0664274 17,15 C17,10.581722 13.418278,7 9,7 C8.93357256,7 8.86733422,7.00080962 8.8012943,7.00241953 Z" fill="#000000" opacity="0.3" />
                            </g>
                            </svg> -->
                            <!--end::Svg Icon-->
                            <!-- </span>Add </a> -->
                            <!--end::Button-->
                        @endif
                    </div>
                </div>
                <div class="card-body">
                    <!--begin: Datatable-->
                    <table id="example" class="table table-separate table-head-custom table-checkable">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Comment</th>
                                <th>Rate</th>
                                <th> Lesson</th>
                                <th>Unit</th>
                                <th>Level</th>
                                <th>Course</th>

                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($lessonreviews as $key => $lessonreview)
                                <tr>
                                    <td>{{ ++$key }}</td>
                                    <td> {{ $lessonreview->comment }} </td>
                                    <td> {{ $lessonreview->rate }} </td>
                                    <td> {{ $lessonreview->user->name }} </td>
                                    <td> Lesson {{ $lessonreview->lesson->number }} </td>
                                    <td> Unit {{ $lessonreview->lesson->unit->number }}</td>
                                    <td> Level {{ $lessonreview->lesson->unit->level->number }} </td>
                                    <td> {{ $lessonreview->lesson->unit->level->course->title }} </td>
                                    <td>
                                        @if (auth()->guard('admin')->user()->hasPermission('delete'))
                                            <a class="btn btn-sm btn-clean btn-icon delete_form" title="Delete"
                                                data-original-title="delete" data-name="lessonreview"
                                                data-id="{{ $lessonreview->id }}">
                                                <span class="svg-icon svg-icon-md">
                                                    <svg xmlns="http://www.w3.org/2000/svg"
                                                        xmlns:xlink="http://www.w3.org/1999/xlink" width="24px"
                                                        height="24px" viewBox="0 0 24 24" version="1.1">
                                                        <g stroke="none" stroke-width="1" fill="none"
                                                            fill-rule="evenodd">
                                                            <rect x="0" y="0" width="24" height="24" />
                                                            <path
                                                                d="M6,8 L6,20.5 C6,21.3284271 6.67157288,22 7.5,22 L16.5,22 C17.3284271,22 18,21.3284271 18,20.5 L18,8 L6,8 Z"
                                                                fill="#000000" fill-rule="nonzero" />
                                                            <path
                                                                d="M14,4.5 L14,4 C14,3.44771525 13.5522847,3 13,3 L11,3 C10.4477153,3 10,3.44771525 10,4 L10,4.5 L5.5,4.5 C5.22385763,4.5 5,4.72385763 5,5 L5,5.5 C5,5.77614237 5.22385763,6 5.5,6 L18.5,6 C18.7761424,6 19,5.77614237 19,5.5 L19,5 C19,4.72385763 18.7761424,4.5 18.5,4.5 L14,4.5 Z"
                                                                fill="#000000" opacity="0.3" />
                                                        </g>
                                                    </svg>
                                                </span>
                                            </a>
                                        @endif
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                    <!--end: Datatable-->
                </div>
            </div>
            <!--end::Card-->

        </div>
        <!--end::Container-->
    </div>
    <!--end::Entry-->


@endsection


@section('js')

    <!--begin::Page Vendors(used by this page)-->
    <script src="{{ asset('assets/Admin/assets/plugins/custom/datatables/datatables.bundle.js') }}"></script>
    <!--end::Page Vendors-->
    <!--begin::Page Scripts(used by this page)-->
    <script src="{{ asset('assets/Admin/assets/js/pages/crud/datatables/basic/scrollable.js') }}"></script>
    <!--end::Page Scripts-->

    <script src="{{ asset('assets/Admin/assets/custom/shared.js') }}"></script>
@endsection
