@extends('Admin.layouts.master')

@section('title')
    Edit Faq
@endsection
@section('level-2')
    <a href="{{route('admin.faq.index')}}">Faq</a>
@endsection
@section('level-3')
Edit
@endsection
@section('page_title', 'Edit Faq')

@section('css')


@endsection

@section('content')
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <!--begin::Card-->
                <div class="card card-custom gutter-b example example-compact">
                    <div class="card-header">
                        <h3 class="card-title">Edit Faq</h3>
                        <div class="card-toolbar">
                            <div class="example-tools justify-content-center">

                            </div>
                        </div>
                    </div>
                    <!--begin::Form-->
                    <form method="post" action="{{ route('admin.faq.update') }}">
                        @csrf
                        @method ('put')
                        <div class="card-body">
                            <div class="form-group mb-8">
                                <input type="hidden" name="id" value="{{ $faq->id }}">

                                <div class="form-group">
                                    <label for="exampleSelect1">FaqCategories
                                        <span class="text-danger">*</span></label>
                                    <select
                                        class="form-control  @error('faq_category_id') is-invalid fparsley-error parsley-error @enderror"
                                        id="exampleSelect1" name="faq_category_id">
                                        <option value="">choose FaqCategories</option>
                                        @foreach ($faqcategories as $faqcategory)
                                            <option
                                                value="{{ $faqcategory->id }}"{{ old('faq_category_id') == $faqcategory->id || (isset($faq->faq_category_id) && $faqcategory->id == $faq->faq_category_id) ? 'selected' : '' }}>
                                                {{ $faqcategory->title }}</option>
                                        @endforeach
                                    </select>
                                    @error('faq_category_id')
                                        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                            role ="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>

                                <div class="form-group">

                                    <label>Question
                                        <span class="text-danger">*</span></label>
                                    <input type="text"
                                        class="form-control @error('question') is-invalid fparsley-error parsley-error @enderror"
                                        placeholder="Question" name="question"
                                        value="{{ old('question', $faq->question) }}" />
                                    @error('question')
                                        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                            role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>
                                <div class="form-group">

                                    <label>Answer
                                        <span class="text-danger">*</span></label>
                                    <input type="text"
                                        class="form-control @error('answer') is-invalid fparsley-error parsley-error @enderror"
                                        placeholder="Answer" name="answer" value="{{ old('answer', $faq->answer) }}" />
                                    @error('answer')
                                        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                            role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>

                            </div>

                            <div class="card-footer">
                                <button type="submit" class="btn btn-primary mr-2">Submit</button>

                            </div>
                        </div>
                    </form><!--end::Form-->
                </div>


                <!--end::Card-->
            </div>
        </div>
    </div><!--end::Container-->


@endsection


@section('js')


@endsection
