@extends('Admin.layouts.master')

@section('title')
    Create Coursefeature
@endsection
@section('level-2')
    <a href="{{route('admin.coursefeature.index')}}">Course feature</a>
@endsection
@section('level-3')
    Create
@endsection
@section('page_title', 'Create Coursefeature')

@section('css')


@endsection

@section('content')
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <!--begin::Card-->
                <div class="card card-custom gutter-b example example-compact">
                    <div class="card-header">
                        <h3 class="card-title">Create Coursefeature</h3>
                        <div class="card-toolbar">
                            <div class="example-tools justify-content-center">

                            </div>
                        </div>
                    </div>
                    <!--begin::Form-->
                    <form method="post" action="{{ route('admin.coursefeature.store') }}">
                        @csrf
                        <div class="card-body">
                            <div class="form-group mb-8">

                                <div class="form-group">
                                    <label>Feature
                                        <span class="text-danger">*</span></label>
                                    <input type="text"
                                        class="form-control @error('feature') is-invalid fparsley-error parsley-error @enderror"
                                        placeholder="feature" name="feature"
                                        value="{{ old('feature', $section->feature ?? '') }}" />
                                    @error('feature')
                                        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                            role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <label for="exampleSelect1">courses
                                        <span class="text-danger">*</span></label>
                                    <select
                                        class="form-control  @error('course_id') is-invalid fparsley-error parsley-error @enderror"
                                        id="exampleSelect1" name="course_id">
                                        <option value="">choose course</option>
                                        @foreach ($courses as $course)
                                            <option value="{{ $course->id }}"
                                                {{ old('course_id') == $course->id ? 'selected' : '' }}>
                                                {{ $course->title }}</option>
                                        @endforeach
                                    </select>
                                    @error('course_id')
                                        <span class="invalid-feedback text-black font-weight-bold text-capitalize mt-2"
                                            role="alert">
                                            <p>{{ $message }}</p>
                                        </span>
                                    @enderror
                                </div>



                            </div>

                            <div class="card-footer">
                                <button type="submit" class="btn btn-primary mr-2">Submit</button>

                            </div>
                        </div>
                    </form><!--end::Form-->
                </div>


                <!--end::Card-->
            </div>
        </div>
    </div>

@endsection


@section('js')


@endsection
