<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateQuizStudentQuestionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('quiz_student_questions', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('quiz_student_id');
            $table->foreign('quiz_student_id')->references('id')->on('quiz_students')->onDelete('CASCADE');
            $table->unsignedBigInteger('question_id');
            $table->foreign('question_id')->references('id')->on('quiz_questions')->onDelete('CASCADE');
            $table->unsignedBigInteger('answer_id');
            $table->foreign('answer_id')->references('id')->on('quiz_answers')->onDelete('CASCADE');
            $table->integer('degree')->default(0);
            $table->integer('status')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('quiz_student_questions');
    }
}
