<?php

namespace App\Service\TapPaymentService;

use GuzzleHttp\Client;



class TapService
{
    use TapTrait;

    private Client $client;
    private $response;

    private string $redirect;
    private string $method;
    private string $url;
    private array $headers;

    private array $customer;
    private float $amount;
    private string $currency;

    public function charge()
    {
        return $this->response = json_decode($this->client()
            ->method('POST')
            ->url(config('tap-payment.charges'))
            ->headers()
            ->createCharge());
    }

    public function getCharge(string $charge_id)
    {
        return $this->response = json_decode(
            $this->client()
                ->method('GET')
                ->url(config('tap-payment.charges'), $charge_id)
                ->headers()
                ->getChargeById()
        );
    }

    public function payUrl(): string
    {
      
        return $this->response->transaction->url;
    }

    public function isSuccessfullyPayed(): bool
    {
        return $this->response->status == 'CAPTURED';
    }
}
