<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use App\Http\Interfaces\Admin\PackageInterface;
use App\Http\Interfaces\Admin\SellerInterface;
use App\Http\Interfaces\Front\SubscribeInterface;
use App\Http\Repositories\Admin\PackageRepository;
use App\Http\Repositories\Front\SubscribeRepository;
use App\Http\Interfaces\Admin\SubscribeInterface as AdminSubscribeInterface;
use App\Http\Repositories\Admin\SellerRepository;
use App\Http\Repositories\Admin\SubscribeRepository as AdminSubscribeRepository;

class RepositoryServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     *
     * @return void
     */
    public function register()
    {
        $this->app->bind(
            'App\Http\Interfaces\HomeInterface',
            'App\Http\Repositories\HomeRepository'
        );

        $this->app->bind(
            'App\Http\Interfaces\Front\FrontInterface',
            'App\Http\Repositories\Front\FrontRepository'
        );

        $this->app->bind(
            'App\Http\Interfaces\Front\AuthInterface',
            'App\Http\Repositories\Front\AuthRepository'
        );

        $this->app->bind(
            'App\Http\Interfaces\Front\DashboardInterface',
            'App\Http\Repositories\Front\DashboardRepository'

        );

        $this->app->bind(
            PackageInterface::class,
            PackageRepository::class
        );

        $this->app->bind(
            SubscribeInterface::class,
            SubscribeRepository::class
        );

        $this->app->bind(
            AdminSubscribeInterface::class,
            AdminSubscribeRepository::class
        );

        $this->app->bind(
            SellerInterface::class,
            SellerRepository::class
        );

        $this->app->bind(
            'App\Http\Interfaces\Front\SocialAuthInterface',
            'App\Http\Repositories\Front\SocialAuthRepository'
        );


        $this->app->bind(
            'App\Http\Interfaces\Admin\DashboardInterface',
            'App\Http\Repositories\Admin\DashboardRepository'

        );

        $this->app->bind(
            'App\Http\Interfaces\Admin\Auth\AuthInterface',
            'App\Http\Repositories\Admin\Auth\AuthRepository'
        );

        $this->app->bind(
            'App\Http\Interfaces\Admin\CourseInterface',
            'App\Http\Repositories\Admin\CourseRepository'

        );

        $this->app->bind(
            'App\Http\Interfaces\Admin\PageInterface',
            'App\Http\Repositories\Admin\PageRepository'

        );
        $this->app->bind(
            'App\Http\Interfaces\Admin\LevelInterface',
            'App\Http\Repositories\Admin\LevelRepository'

        );
        $this->app->bind(

            'App\Http\Interfaces\Admin\UnitInterface',
            'App\Http\Repositories\Admin\UnitRepository'

        );
        $this->app->bind(

            'App\Http\Interfaces\Admin\SettingInterface',
            'App\Http\Repositories\Admin\SettingRepository'

        );
        $this->app->bind(


            'App\Http\Interfaces\Admin\LessonInterface',
            'App\Http\Repositories\Admin\LessonRepository',
        );
        $this->app->bind(
            'App\Http\Interfaces\Admin\SectionInterface',
            'App\Http\Repositories\Admin\SectionRepository'


        );
        $this->app->bind(

            'App\Http\Interfaces\Admin\SectionItemInterface',
            'App\Http\Repositories\Admin\SectionItemRepository'

        );
        $this->app->bind(

            'App\Http\Interfaces\Admin\SliderInterface',
            'App\Http\Repositories\Admin\SliderRepository'

        );
        $this->app->bind(

            'App\Http\Interfaces\Admin\FlashCardInterface',
            'App\Http\Repositories\Admin\FlashCardRepository',
        );

        $this->app->bind(


            'App\Http\Interfaces\Admin\LessonFaqInterface',
            'App\Http\Repositories\Admin\LessonFaqRepository',
        );

        $this->app->bind(


            'App\Http\Interfaces\Admin\LessonReviewInterface',
            'App\Http\Repositories\Admin\LessonReviewRepository',
        );
        $this->app->bind(

            'App\Http\Interfaces\Admin\StudentInterface',
            'App\Http\Repositories\Admin\StudentRepository',
        );
        $this->app->bind(
            'App\Http\Interfaces\Admin\BlogInterface',
            'App\Http\Repositories\Admin\BlogRepository',
        );
        $this->app->bind(


            'App\Http\Interfaces\Admin\CourseGoalInterface',
            'App\Http\Repositories\Admin\CourseGoalRepository',
        );

        $this->app->bind(

            'App\Http\Interfaces\Admin\CourseFeatureInterface',
            'App\Http\Repositories\Admin\CourseFeatureRepository',
        );

        $this->app->bind(
            'App\Http\Interfaces\Admin\RegisterVideoInterface',
            'App\Http\Repositories\Admin\RegisterVideoRepository',
        );
        $this->app->bind(
            'App\Http\Interfaces\Admin\FaqCategoryInterface',
            'App\Http\Repositories\Admin\FaqCategoryRepository',
        );
        $this->app->bind(
            'App\Http\Interfaces\Admin\FaqInterface',
            'App\Http\Repositories\Admin\FaqRepository',
        );
        $this->app->bind(
            'App\Http\Interfaces\Admin\TestInterface',
            'App\Http\Repositories\Admin\TestRepository',
        );

        $this->app->bind(
            'App\Http\Interfaces\Admin\TestQuestionInterface',
            'App\Http\Repositories\Admin\TestQuestionRepository',
        );


        $this->app->bind(
            'App\Http\Interfaces\Admin\TestAnswerInterface',
            'App\Http\Repositories\Admin\TestAnswerRepository',
        );


        $this->app->bind(
            'App\Http\Interfaces\Front\PlacementTestInterface',
            'App\Http\Repositories\Front\PlacementTestRepository',
        );

        $this->app->bind(
            'App\Http\Interfaces\Admin\ReviewInterface',
            'App\Http\Repositories\Admin\ReviewRepository',
        );

        $this->app->bind(
            'App\Http\Interfaces\Admin\ContactInterface',
            'App\Http\Repositories\Admin\ContactRepository',
        );

        $this->app->bind(
            'App\Http\Interfaces\Admin\QuizInterface',
            'App\Http\Repositories\Admin\QuizRepository',
        );

        $this->app->bind(
            'App\Http\Interfaces\Admin\QuizQuestionInterface',
            'App\Http\Repositories\Admin\QuizQuestionRepository',
        );

        $this->app->bind(
            'App\Http\Interfaces\Admin\QuizAnswerInterface',
            'App\Http\Repositories\Admin\QuizAnswerRepository',
        );

        $this->app->bind(
            'App\Http\Interfaces\Front\LessonQuizInterface',
            'App\Http\Repositories\Front\LessonQuizRepository',
        );

        $this->app->bind(
            'App\Http\Interfaces\Front\StudentInterface',
            'App\Http\Repositories\Front\StudentRepository',
        );

        $this->app->bind(
            'App\Http\Interfaces\Front\MasteryInterface',
            'App\Http\Repositories\Front\MasteryRepository',
        );

        $this->app->bind(
            'App\Http\Interfaces\Admin\AdminInterface',
            'App\Http\Repositories\Admin\AdminRepository',
        );


        $this->app->bind(
            'App\Http\Interfaces\Admin\CountryInterface',
            'App\Http\Repositories\Admin\CountryRepository',
        );

        $this->app->bind(
            'App\Http\Interfaces\Admin\RoleInterface',
            'App\Http\Repositories\Admin\RoleRepository',
        );

        $this->app->bind(
            'App\Http\Interfaces\Admin\DownloadInterface',
            'App\Http\Repositories\Admin\DownloadRepository',
        );


        $this->app->bind(
            'App\Http\Interfaces\Admin\DownloadAttachementInterface',
            'App\Http\Repositories\Admin\DownloadAttachementRepository',
        );
        $this->app->bind(
            'App\Http\Interfaces\Admin\UplodedFileInterface',
            'App\Http\Repositories\Admin\UplodedFileRepository',
        );

        $this->app->bind(
            'App\Http\Interfaces\Admin\GuidesCategoryInterface',
            'App\Http\Repositories\Admin\GuidesCategoryRepository',
        );

        $this->app->bind(
            'App\Http\Interfaces\Admin\GuidesSubCategoryInterface',
            'App\Http\Repositories\Admin\GuidesSubCategoryRepository',
        );

        $this->app->bind(
            'App\Http\Interfaces\Admin\GuideInterface',
            'App\Http\Repositories\Admin\GuideRepository',
        );

        $this->app->bind(
            'App\Http\Interfaces\Admin\GuideDetailInterface',
            'App\Http\Repositories\Admin\GuideDetailRepository',
        );

        $this->app->bind(
            'App\Http\Interfaces\Admin\CandlyLevelInterface',
            'App\Http\Repositories\Admin\CandlyLevelRepository',
        );

        $this->app->bind(
            'App\Http\Interfaces\Front\ForgetPasswordInterface',
            'App\Http\Repositories\Front\ForgetPasswordRepository',
        );

        $this->app->bind(
            'App\Http\Interfaces\Front\EmailVerificationInterface',
            'App\Http\Repositories\Front\EmailVerificationRepository',
        );


        $this->app->bind(
            'App\Http\Interfaces\Admin\MessagesInterface',
            'App\Http\Repositories\Admin\MessagesRepository',
        );
    }
    /**
     * Bootstrap services.
     *
     * @return void
     */
    public function boot()
    {
        //
    }
}
