<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Seller extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'email',
        'phone',
        'code',
        'percentage',
        'counter'
    ];

    public function subscribes()
    {
        return $this->hasMany(Subscribe::class, 'code', 'code');
    }
}
