<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class QuizStudent extends Model
{
    use HasFactory;
    protected $fillable = [
        'total_degree', 'user_id', 'quiz_id', 'medal', 'status'

    ];


    public function quiz()
    {

        return $this->belongsTo(Quiz::class, 'quiz_id')->with('lesson');
    }

    public function studentQuestions()
    {
        return $this->hasMany(QuizStudentQuestion::class, 'quiz_student_id');
    }
}
