<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class QuizQuestion extends Model
{
    use HasFactory;
    protected $fillable = [
        'quiz_id', 'question', 'type', 'status', 'title'
    ];

    public function quiz()
    {
        return $this->belongsTo(Quiz::class, 'quiz_id');
    }
    public function answers()
    {

        return $this->hasMany(QuizAnswer::class, 'question_id');
    }

    public function answer()
    {

        return $this->hasOne(QuizAnswer::class, 'question_id');
    }

    public function audios()
    {

        return $this->morphOne(Audio::class, 'audioable');
    }



    public function images()
    {

        return $this->morphMany(Image::class, 'imageable');
    }

    public function userMasteryQuiz()
    {

        return  $this->hasMany(UserMasteryQuiz::class, 'question_id');
    }
    public function userMasteryQuizdue()
    {

        return $this->hasMany(UserMasteryQuiz::class, 'question_id')
            ->where([['due', '>=', 3], ['user_id', auth()->user()->id]]);
    }
    public function dueUserMasteryQuiz()
    {

        return $this->hasMany(UserMasteryQuiz::class, 'question_id')
            ->where([['due', '<=', 3], ['user_id', auth()->user()->id]])
            ->orWhere([['due', '>', 3], ['updated_at', '<=', Carbon::now()->subDays(2)->toDateTimeString()]]);
    }
}
