<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Level extends Model
{
    use HasFactory;
    use \Staudenmeir\EloquentHasManyDeep\HasRelationships;

    protected $append = [
        'FlashCard', 'QuizQuestions', 'MasteryFlashCard', 'MasteryQuiz'
    ];

    protected $fillable = [
        'course_id', 'number', 'type', 'price', 'discount', 'status'
    ];


    public function course()
    {
        return $this->belongsTo(Course::class, 'course_id');
    }

    public function units()
    {
        return $this->hasMany(Unit::class, 'level_id')->with('lessons');
    }

    public function unit()
    {
        return $this->hasOne(Unit::class, 'level_id')->with('lesson');
    }

    // public function packages()
    // {
    //     return $this->belongsToMany(Package::class);
    // }

    public function lessons()
    {
        return $this->hasManyThrough(Lesson::class, Unit::class)->withCount('flashCards')->withCount('questions');
    }

    public function flashCards()
    {
        return $this->hasManyDeepFromRelations($this->lessons(), (new Lesson())->flashCards())->withCount('userMastery');
    }


    public function questions()
    {
        return $this->hasManyDeepFromRelations($this->lessons(), (new Lesson())->questions())->withCount('userMasteryQuizdue');
    }


    public function getFlashCardAttribute()
    {
        return $this->lessons->sum(function ($lesson) {
            return $lesson->flash_cards_count;
        });
    }
    public function getMasteryFlashCardAttribute()
    {
        return $this->flashCards->sum(function ($flashCard) {
            return $flashCard->user_mastery_count;
        });
    }
    public function getMasteryQuizAttribute()
    {
        return $this->flashCards->sum(function ($flashCard) {
            return $flashCard->user_mastery_quiz_due_count;
        });
    }

    public function getQuizQuestionsAttribute()
    {
        return $this->lessons->sum(function ($lesson) {
            return $lesson->questions_count;
        });
    }
}
