<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class LessonStudent extends Model
{
    use HasFactory;

    protected $fillable=[
        'user_id','lesson_id','start_date','status','unit_id','level_id','end_date'
    ];


    public function lesson(){
        return $this->belongsTo(Lesson::class,'lesson_id')->with('levels');
    }

    public function unit(){
        return $this->belongsTo(Unit::class,'unit_id')->with('level');
    }

    
    
}
