<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class GuideDetail extends Model
{
    use HasFactory;

    protected $fillable = [
        'title',
        'guide_id',
        'description',
        'link'

    ];
    public function guide()
    {
        return $this->belongsTo(Guide::class, 'guide_id');
    }

    public function images()
    {

        return $this->morphMany(Image::class, 'imageable');
    }
}
