<?php

namespace App\Models;

use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Laratrust\Traits\LaratrustUserTrait;

class Admin extends Authenticatable
{
    use LaratrustUserTrait;
    use HasApiTokens, HasFactory;
    protected $guarded=[];
    protected $fillable = [
    'name', 'email', 'password',
    ];


    public function sendMessages()
    {
        return $this->morphMany(Message::class, 'sender');
    }

    public function recievedMessages()
    {
        return $this->morphMany(Message::class, 'recipient');
    }


}
