<?php

namespace App\Http\Requests\Admin\Lesson;

use Illuminate\Foundation\Http\FormRequest;

class CreateLessonRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            // 'number'     => 'required|numeric',
            'unit_id'       => 'required|exists:units,id',
            'title'         => 'required',
            'description'   => 'required',
            'link'          => 'nullable|url',
            'audio'         => 'nullable|mimes:mp3,wav,ogg|max:200480',
            // 'video'         => 'nullable|mimes:mp4,avi,mov,wmv|max:200480',
            // 'audio'         => 'nullable|string',
            'video'         => 'nullable|string',
            'image'         => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            'notes'         => 'nullable|mimes:pdf|max:2048',
        ];
    }
}
