<?php

namespace App\Http\Requests\Admin\FlashCards;

use Illuminate\Foundation\Http\FormRequest;

class UpdateFlashCardRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'id'             => 'required|exists:flash_cards,id',
            'lesson_id'      => 'required|exists:lessons,id',
            'english_word'   => 'required',
            'arabic_word'    => 'required',
            'audio'          => 'nullable|mimes:mp3,wav,ogg|max:2048',
        ];
    }
}
