<?php

namespace App\Http\Repositories\Front;

use App\Models\Seller;
use App\Models\Package;
use App\Models\Subscribe;
use App\Http\Interfaces\Front\SubscribeInterface;
use Carbon\Carbon;
use PhpOffice\PhpSpreadsheet\Calculation\Logical\Boolean;

class SubscribeRepository implements SubscribeInterface
{
    protected $subscribeModel;
    protected $packageModel;
    public Package $package;

    public function __construct(
        Subscribe $subscribe,
        Package $package,
    ) {
        $this->subscribeModel = $subscribe;
        $this->packageModel = $package;
    }

    public function store($data): Subscribe
    {
        
    

        $this->package =  $this->packageModel->select(['price'])->findOrFail($data['package_id']);
        
        //if the user has failed subscription update the updated_at
        // else (has previous subscription or not) create new record
        if ($this->checkIfUserHasFailedSubscription(auth()->id())) {
           
            return  $this->subscribeModel::where('user_id', auth()->id())->tap(function ($query) use ($data) {
                $query->update([
                    'updated_at' => Carbon::now(),
                    'created_at' => Carbon::now(),
                    'code' => $data['code'] ?? null,
                    'paid_amount' => self::calcPackageCost($this->package->price, $data['code']),
                ] + $data);
            })->first();
        }
        
        
        return $this->subscribeModel::create(
            [
                'user_id' => auth()->id(),
                'code' => $data['code'] ?? null,
                'paid_amount' => self::calcPackageCost($this->package->price, $data['code']),

            ] + $data
        );
        // dd( auth()->id());
    }

    private static function calcPackageCost($price, $code = null)
    {
        if ($code) {
            return $price - ($price * self::getCodePercentage($code));
        }

        return $price;
    }

    private static function getCodePercentage($code)
    {
        return Seller::where('code', $code)->value('percentage') / 100;
    }
    private function checkIfUserHasFailedSubscription($user_id): bool
    {
        return (bool)$this->subscribeModel->where('user_id', $user_id)->where('status', 0)->first();
    }
}
