<?php

namespace App\Http\Repositories\Front;

use Carbon\Carbon;
use App\Models\Level;
use App\Models\Course;
use App\Models\FlashCard;
use App\Models\UserMasteryQuiz;
use App\Models\UserMasterFlashCard;
use Illuminate\Database\Eloquent\Model;
use App\Http\Interfaces\Front\MasteryInterface;
use App\Models\Download;

class MasteryRepository implements MasteryInterface
{

    protected $courseModel;
    protected $levelModel;
    protected $flashCardModel;
    protected $downloadModel;




    public function __construct(
        Course $course,
        Level $level,

        FlashCard $flashcard,
        Download $download,


    ) {
        $this->courseModel = $course;
        $this->levelModel = $level;
        $this->flashCardModel = $flashcard;
        $this->downloadModel = $download;
    }

    public function mastery()
    {
        return view('Front.dashboard.pages.mastery');
    }


    public function masteryFlashcard()
    {
        $courses = $this->courseModel::with( 'lessons', 'flashCards')->get();
        return view('Front.dashboard.pages.mastery-flashcard', compact('courses'));
    }

    public function flashMasterDeck($id)
    {
        $course = $this->courseModel::with('units')->find($id);
        return view('Front.dashboard.pages.mastery-flashcard-decks-2', compact('course'));
    }

    public function masteryFlashcardCollection($id)
    {

        $level = $this->levelModel::with('flashcards')->find($id);
        $flash = $level->flashcards->filter(function ($item) {

            return  $item->dueUserMasteryFlashCard->count() !== 0;
        })->values()->take(10);
        if (empty($flash)) {
            $flashcards = $flash;
        } else {
            $flashcards = $level->flashcards;
        }

        return view('Front.dashboard.pages.masteryFlashcardCollection', compact('level', 'flashcards'));
    }

    public function masteryResult($id)
    {

        $userflash = UserMasterFlashCard::where([['user_id', auth()->user()->id], [
            'updated_at', '>',
            Carbon::now()->subMinutes(5)->toDateTimeString()
        ]])->with('flashCard')->get();

        return view('Front.dashboard.pages.result-3', compact('userflash'));
    }

    public function masteryQuiz()
    {
        $courses = $this->courseModel::with('units', 'lessons')->get();

        return view('Front.dashboard.pages.mastery-quiz', compact('courses'));
    }


    public function quizDeck($id)
    {

        $course = $this->courseModel::with('units')->find($id);
        return view('Front.dashboard.pages.mastery-quiz-deck', compact('course'));
    }

    public function masteryQuizCollection($id)
    {

        $level = $this->levelModel::with('questions')->find($id);
        $ques = $level->questions->filter(function ($item) {

            return  $item->dueUserMasteryQuiz->count() !== 0;
        })->values()->take(10);
        if (empty($ques)) {
            $questions = $ques;
        } else {
            $questions = $level->questions;
        }


        return view('Front.dashboard.pages.masteryquizcollection', compact('level', 'questions'));
    }

    public function masteryQuizResult()
    {

        $userques = UserMasteryQuiz::where([['user_id', auth()->user()->id], [
            'updated_at', '>',
            Carbon::now()->subMinutes(5)->toDateTimeString()
        ]])->with('quizQuestions')->get();

        return view('Front.dashboard.pages.quiz-mastery-result', compact('userques'));
    }


    public function downloadCenter()
    {
        $downloads = $this->downloadModel::with('downloadattachement')->get();
        return view('Front.dashboard.pages.dawnloadcenter', compact('downloads'));
    }
}
