<?php

namespace App\Http\Repositories\Front;

use App\Models\User;
use Illuminate\Support\Str;
use App\Service\UserOtpService;
use App\Mail\ForgetPasswordEmail;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Session;
use App\Http\Interfaces\Front\ForgetPasswordInterface;
use App\Mail\UserOtpEmail;

class ForgetPasswordRepository implements ForgetPasswordInterface
{

    public function index()
    {
        return view('Front.Auth.forgetpassword');
    }

    public function getEmail($request)
    {
        $user = User::where('email', $request->email)->first();

        if (is_null($user)) {
            session()->flash('error', 'This account not found ! !');

            return redirect()->back();
        }

        $code = UserOtpService::generateCode();

        $user->update(['otp_code' => $code]);

        Mail::to($user->email)->send(new UserOtpEmail($code));

        return redirect()->route('resetpasswordpage')->with('success', 'Code sent to your email ');
    }

    public function changePasswordPage()
    {

        return view('Front.Auth.newpassword');
    }

    public function resetPassword($request)
    {

        $user = User::where('otp_code', $request->token)->first();

        if (!$user) {
            session()->flash('error', 'Code Not Found. !');

            return redirect()->back();
        }

        $user->update([
            'password' => Hash::make($request->password),
            'otp_code' => null,
        ]);

        session()->flash('success', 'Password Successfully Updated!');

        return redirect()->route('loginpage');
    }
}
