<?php

namespace App\Http\Repositories\Admin;


use App\Models\User;
use App\Models\Country;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Maatwebsite\Excel\Facades\Excel;
use RealRashid\SweetAlert\Facades\Alert;
use App\Http\Traits\SendNotificationTrait;
use App\Http\Interfaces\Admin\StudentInterface;
use App\Imports\StudentImport;

class StudentRepository implements StudentInterface
{


    use SendNotificationTrait;
    protected $userModel;
    protected $countryModel;

    public function __construct(User $student, Country $country)
    {

        $this->userModel = $student;
        $this->countryModel = $country;
    }
    public function index()
    {
        $students =  $this->userModel::with('country')->get();

        return view('Admin.student.index', compact('students'));
    }

    public function create()
    {
        $countries = $this->countryModel::get();
        return view('Admin.student.create', compact('countries'));
    }

    public function store($request)
    {

        $student =  $this->userModel::create([
            'name' => $request->name,
            'email' => $request->email,
            'password' => Hash::make($request->password),
            'country_id' => $request->country_id
        ]);


        Alert::success('success', ' ٍStudent Added Successfully');
        return redirect()->route('admin.student.index');
    }

    public function import()
    {
        return view('Admin.student.import');
    }

    public function upimport($request)
    {
        request()->validate([
            'file' => 'required|mimes:xlsx',
        ]);
        $file = $request->file('file')->store('files');

        Excel::import(new StudentImport, $file);
        Alert::success('success', 'Imported Successfully');
        return redirect()->route('admin.student.index');
    }

    public function edit($id)
    {
        $student = $this->userModel::find($id);
        $countries = $this->countryModel::get();

        return view('Admin.student.edit', compact('student', 'countries'));
    }


    public function update($request)
    {

        $student = $this->userModel::find($request->id);
        $student->update([

            'name' => $request->name,
            'email' => $request->email,
            'password' => isset($request->password) ? Hash::make($request->password) : $student->password,
            'country_id' => $request->country_id,
            'is_active' => ($student->is_active == 1 ?  0 : 1)

        ]);


        Alert::success('success', ' ٍStudent  updated Successfully');
        return redirect()->route('admin.student.index');
    }

    public function  destroy($id)
    {
        $student = $this->userModel::find($id);

        if ($student) {
            $student->delete();
            return  1;
        }
        return  0;
    }

    public function notification($id)
    {
        $student = $this->userModel::find($id);
        return view('Admin.student.notification', compact('student'));
    }
    public function sendNotification($request)
    {

        $this->sendNotify($request->student_id, $request->message);
        Alert::success('success', ' ٍSent Successfully');
        return redirect()->route('admin.student.index');
    }
}
