<?php

namespace App\Http\Repositories\Admin;

use App\Models\Page;
use App\Models\Section;
use App\Http\Traits\ImageTrait;
use RealRashid\SweetAlert\Facades\Alert;
use App\Http\Interfaces\Admin\SectionInterface;
use Illuminate\Support\Facades\Route;

class SectionRepository implements SectionInterface{
    use ImageTrait;
    protected $sectionModel;
    protected $pageModel;

    public function __construct(Section $section ,Page $page){
        $this->pageModel =$page;
        $this->sectionModel =$section;

    }

    public function index()
    {
        if (Route::is('admin.sub.section*')) {
            $sections =  $this->sectionModel::where('sub_section', '1')->with('page')->get();
            return view('Admin.subsection.index',compact('sections'));
        }

        $sections= $this->sectionModel::where('sub_section', '0')->with('page')->get();
        return view('Admin.section.index',compact('sections'));

    }

    public function create()
    {
        if (Route::is('admin.sub.section*')) {
            $pages=  $this->pageModel::where('subpage', '1')->get();
            return view('Admin.subsection.create',compact('pages'));
        }

        $pages=  $this->pageModel::where('subpage', '0')->get();
        return view('Admin.section.create',compact('pages'));
    }

    public function store($request)
    {
        $section =  $this->sectionModel::create([
            'title'             =>   $request->title,
            'description'       =>   $request->description,
            'page_id'           =>   $request->page_id,
            'sub_section'       =>   Route::is('admin.sub.section*') ? '1' : '0'
        ]);

        if ($request->hasFile('image')) {
            $filename = time() . '.' . $request->image->extension();
            $images =  $this->uploadImage($request->image, $filename, 'sectionimage');
            $image= 'images/sectionimage/'.$images;
            $section->images()->create([
                'image' => $image,
                'type' => 'image',
            ]);
        }

        Alert::success('success', ' Section Added Successfully');
        if (Route::is('admin.sub.section*')) {
            return redirect()->route('admin.sub.section.index');
        }
        return redirect()->route('admin.section.index');
    }

    public function edit($id)
    {
        if (Route::is('admin.sub.section*')) {
            $section =$this->sectionModel::find($id);
            $pages =$this->pageModel::where('subpage', '1')->get();
            return view('Admin.subsection.edit',compact('section','pages'));
        }

        $section =$this->sectionModel::find($id);
        $pages =$this->pageModel::where('subpage', '0')->get();
        return view('Admin.section.edit',compact('section','pages'));

    }

    public function update($request){

        $section =  $this->sectionModel::find($request->id);
        $section->update([
            'title'             =>   $request->title,
            'description'       =>   $request->description,
            'page_id'           =>   $request->page_id,
            'sub_section'       =>  Route::is('admin.sub.section*') ? '1' : '0'
        ]);
        if ($request->hasFile('image')) {
            $section->images()->delete();
            $filename = time() . '.' . $request->image->extension();
            $images =  $this->uploadImage($request->image, $filename, 'sectionimage');
            $image= 'images/sectionimage/'.$images;
            $section->images()->create([
                'image' => $image,
                'type' => 'image',
            ]);
        }

        Alert::success('success', ' Section updated Successfully');
        if (Route::is('admin.sub.section*')) {
            return redirect()->route('admin.sub.section.index');
        }
        return redirect()->route('admin.section.index');
    }

    public function  destroy($id){
        $section= $this->sectionModel::find($id);

        if($section){
            $section->delete();
            return  1;
        }

       return 0 ;

    }
}
