<?php

namespace App\Http\Repositories\Admin;



use App\Models\QuizAnswer;
use App\Models\QuizQuestion;
use App\Http\Traits\ImageTrait;
use Illuminate\Support\Facades\DB;
use RealRashid\SweetAlert\Facades\Alert;
use App\Http\Interfaces\Admin\QuizQuestionInterface;

class QuizQuestionRepository implements QuizQuestionInterface
{

    use ImageTrait;
    protected $quizQuestionModel;
    protected $quizAnswerModel;

    public function __construct(QuizQuestion $quizQuestion, QuizAnswer $quizAnswer)
    {

        $this->quizQuestionModel = $quizQuestion;
        $this->quizAnswerModel = $quizAnswer;
    }
    public function index($id)
    {
        $quizQuestions =  $this->quizQuestionModel::where('quiz_id', $id)->with('Answers')->get();

        return view('Admin.quizquestion.index', compact('quizQuestions', 'id'));
    }


    public function show($id)
    {
        $quizQuestion = $this->quizQuestionModel::with('answers')->find($id);
        return view('Admin.quizquestion.show', compact('quizQuestion'));
    }

    public function create($id)
    {

        return view('Admin.quizquestion.create', compact('id'));
    }

    public function store($request)
    {

        DB::transaction(function () use ($request) {
            $quizQuestion =  $this->quizQuestionModel::create([

                'question' => $request->question,
                'title'  => $request->title,
                'type'     => $request->type,
                'quiz_id'  => $request->quiz_id


            ]);
            if ($request->hasFile('images')) {


                foreach ($request->images as $key => $image) {
                    $filename = time() . $key . '.' . $image->extension();
                    $images =  $this->uploadImage($image, $filename, 'quizquestionimage');
                    $name = 'images/quizquestionimage/' . $images;

                    $quizQuestion->images()->create([
                        'image' => $name,
                        'type' => 'image',
                    ]);
                }
            }

            if ($request->hasFile('audio')) {



                $filename = time() . '.' . $request->audio->extension();
                $audios =  $this->uploadImage($request->audio, $filename, 'quizaquestionaudio');
                $name = 'images/quizaquestionaudio/' . $audios;

                $quizQuestion->audios()->create([
                    'audio' => $name,
                    'type' => 'audio',
                ]);
            }



            foreach ($request->answer as $key => $ans) {

                $answer = $this->quizAnswerModel::create([
                    'answer'      => $ans['ans'],
                    'question_id' => $quizQuestion->id,
                    'is_correct'  => isset($ans['correct']) ? 1 : 0,
                    'status'      => (!is_null($ans['status']) ? $ans['status'] :  0)

                ]);

                if (isset($ans['image'])) {


                    $filename = time() . '.' . $ans['image']->extension();
                    $images =  $this->uploadImage($ans['image'], $filename, 'quizanswerimage');
                    $name = 'images/quizanswerimage/' . $images;

                    $answer->images()->create([
                        'image' => $name,
                        'type' => 'image',
                    ]);
                }

                if (isset($ans['audio'])) {


                    $filename = time() . '.' . $ans['audio']->extension();
                    $audios =  $this->uploadImage($ans['audio'], $filename, 'quizansweraudio');
                    $name = 'images/quizansweraudio/' . $audios;

                    $answer->audios()->create([
                        'audio' => $name,
                        'type' => 'audio',
                    ]);
                }
            }
        });


        Alert::success('success', ' TestQuestion Added Successfully');
        return redirect()->route('admin.quizquestion.index', $request->quiz_id);
    }


    public function edit($id)
    {
        $quizQuestion = $this->quizQuestionModel::with('answers')->find($id);


        return view('Admin.quizquestion.edit', compact('quizQuestion'));
    }


    public function update($request)
    {

        $quizQuestion = $this->quizQuestionModel::find($request->id);
        DB::transaction(function () use ($request, $quizQuestion) {

            $quizQuestion->update([

                'question' => $request->question,
                'title'  => $request->title,
                'type'     => $request->type,



            ]);
            if ($request->hasFile('images')) {


                $quizQuestion->images()->delete();
                foreach ($request->images as $key => $image) {
                    $filename = time() . $key . '.' . $image->extension();
                    $images =  $this->uploadImage($image, $filename, 'quizquestionimage');
                    $name = 'images/quizquestionimage/' . $images;

                    $quizQuestion->images()->create([
                        'image' => $name,
                        'type' => 'image',
                    ]);
                }
            }

            if ($request->hasFile('audio')) {


                $quizQuestion->audios()->delete();
                $filename = time() . '.' . $request->audio->extension();
                $audios =  $this->uploadImage($request->audio, $filename, 'quizansweraudio');
                $name = 'images/quizansweraudio/' . $audios;

                $quizQuestion->audios()->create([
                    'audio' => $name,
                    'type' => 'audio',
                ]);
            }
        });


        Alert::success('success', ' TestQuestion  updated Successfully');
        return redirect()->route('admin.quizquestion.index', $quizQuestion->quiz_id);
    }

    public function  destroy($id)
    {
        $quizQuestion = $this->quizQuestionModel::find($id);

        if ($quizQuestion) {

            foreach ($quizQuestion->answers as $answer) {
                $answer->images()->delete();
            }
            $quizQuestion->audios()->delete();
            $quizQuestion->images()->delete();
            $quizQuestion->delete();

            return 1;
        }
        return 0;
    }
}
