<?php

namespace App\Http\Repositories\Admin;

use App\Models\Package;
use Illuminate\Database\Eloquent\Collection;
use App\Http\Interfaces\Admin\PackageInterface;

class PackageRepository implements PackageInterface
{

    protected $packageModel;

    public function __construct(Package $package)
    {
        $this->packageModel = $package;
    }

    public function index(): Collection
    {
        return $this->packageModel::with(['courses'])->get();
    }

    public function store($data): Package
    {
        $package = $this->packageModel::create($data);
        $package->courses()->sync($data['courses']);
        return $package;
    }

    public function update(Package $package, array $data): void
    {
        $package->update($data);
        $package->courses()->sync($data['courses']);
    }

    public function destroy(Package $package): void
    {
        $package->delete();
    }
}
