<?php
namespace App\Http\Repositories\Admin;

use App\Models\Level;

use App\Http\Traits\ImageTrait;
use RealRashid\SweetAlert\Facades\Alert;
use App\Http\Interfaces\Admin\LevelInterface;
use App\Models\Course;

class LevelRepository implements LevelInterface
{
    use ImageTrait;
    protected $levelModel;
    protected $courseModel;
    public function __construct(Level $level, Course $course)
    {
        $this->levelModel = $level;
        $this->courseModel = $course;
    }
    public function index()
    {
        $levels = $this->levelModel::with('course')->get();
        return view('Admin.level.index', compact('levels'));
    }

    public function create()
    {
        $courses = $this->courseModel::get();
        return view('Admin.level.create', compact('courses'));
    }

    public function store($request)
    {
        $maxNumberLevel = $this->levelModel::whereCourseId($request->course_id)->max('number');

        $level = $this->levelModel::create([
            'course_id' => $request->course_id,
            'number' => $maxNumberLevel + 1,
            // 'type' => $request->type,
            // 'price' => $request->price,
            // 'discount' => $request->discount,
        ]);
        Alert::success('success', ' Level Added Successfully');
        return redirect()->route('admin.level.index');
    }

    public function edit($id)
    {
        $level = $this->levelModel::find($id);
        $courses = $this->courseModel::get();
        return view('Admin.level.edit', compact('level', 'courses'));
    }

    public function update($request)
    {
        $level = $this->levelModel::find($request->id);
        $level->update([
            'course_id' => $request->course_id,
            'number' => $request->number,
            'type' => $request->type,
            'price' => $request->price,
            'discount' => $request->discount,
        ]);
        Alert::success('success', ' Level  updated Successfully');
        return redirect()->route('admin.level.index');
    }

    public function destroy($id)
    {
        $level = $this->levelModel::find($id);

        if ($level) {
            $level->delete();
            return 1;
        }
        return 0;
    }
}
