<?php

namespace App\Http\Repositories\Admin;


use App\Models\Guide;
use App\Models\GuideDetail;
use RealRashid\SweetAlert\Facades\Alert;
use App\Http\Interfaces\Admin\GuideDetailInterface;
use App\Http\Traits\ImageTrait;

class GuideDetailRepository implements GuideDetailInterface
{


    use ImageTrait;
    protected $guidesDetailModel;
    protected $guideModel;


    public function __construct(GuideDetail $guidesDetail, Guide $guide)
    {
        $this->guidesDetailModel = $guidesDetail;
        $this->guideModel = $guide;
    }
    public function index()
    {
        $guidedetails =  $this->guidesDetailModel::get();
        return view('Admin.guidedetail.index', compact('guidedetails'));
    }
    public function create()
    {
        $guides = $this->guideModel::get();
        return view('Admin.guidedetail.create', compact('guides'));
    }

    public function store($request)
    {
        $request->validate([
            'title'                 => 'required',
            'description'           => 'required',
            'guide_id'              => 'required',
            'link'                  => 'required',
            'image'                 => 'required',
        ]);

        $guidesDetail =  $this->guidesDetailModel::create([
            'title'             =>  $request->title,
            'description'       =>  $request->description,
            'guide_id'          =>  $request->guide_id,
            'link'              =>  $request->link
        ]);


        if ($request->hasFile('image')) {
            $filename = time() . '.' . $request->image->extension();
            $images =  $this->uploadImage($request->image, $filename, 'guidedetailimage');
            $image = 'images/guidedetailimage/' . $images;
            $guidesDetail->images()->create([
                'image' => $image,
                'type' => 'image',
            ]);
        }
        Alert::success('success', ' guidesDetail Added Successfully');
        return redirect()->route('admin.guidedetail.index');
    }

    public function edit($id)
    {
        $guidedetail = $this->guidesDetailModel::find($id);
        $guides = $this->guideModel::get();
        return view('Admin.guidedetail.edit', compact('guidedetail', 'guides'));
    }

    public function update($request)
    {
        $request->validate([
            'title'                 => 'required',
            'description'           => 'required',
            'guide_id'              => 'required',
            'link'                  => 'required',
        ]);

        $guideDetail =  $this->guidesDetailModel::find($request->id);

        if ($request->hasFile('image')) {
            $filename = time() . '.' . $request->image->extension();
            $images =  $this->uploadImage($request->image, $filename, 'guidedetailimage');
            $image = 'images/guidedetailimage/' . $images;
            $guideDetail->images()->create([
                'image' => $image,
                'type' => 'image',
            ]);
        }

        $guideDetail->update([
            'title'             =>  $request->title,
            'description'       =>  $request->description,
            'guide_id'          =>  $request->guide_id,
            'link'              =>  $request->link
        ]);
        Alert::success('success', ' guide Detail  updated Successfully');
        return redirect()->route('admin.guidedetail.index');
    }

    public function  destroy($id)
    {
        $guidesDetail = $this->guidesDetailModel::find($id);

        if ($guidesDetail) {
            $guidesDetail->delete();
            return  1;
        }

        return 0;
    }
}
