<?php

namespace App\Http\Repositories\Admin;

use App\Models\Download;
use RealRashid\SweetAlert\Facades\Alert;
use App\Http\Interfaces\Admin\DownloadInterface;
use App\Http\Traits\ImageTrait;

class DownloadRepository implements DownloadInterface{

    use ImageTrait;

    protected $downloadModel;


    public function __construct(Download $download){
        $this->downloadModel =$download;
    }
    public function index(){
        $downloads=  $this->downloadModel::get();
        return view('Admin.download.index',compact('downloads'));
    }
    public function create(){
        return view('Admin.download.create');
    }

    public function store($request)
    {
        $request->validate([
            'title' => 'required',
            'icon'  => 'required'
        ]);

        if ($request->hasFile('icon')) {
            $filename = time() . '.' . $request->icon->extension();
            $icons =  $this->uploadImage($request->icon, $filename, 'download');
            $icon= 'images/download/'.$icons;

        }
        $download =  $this->downloadModel::create([
            'title'      =>  $request->title,
            'icon'       =>   $icon
        ]);
        Alert::success('success', ' download Added Successfully');
        return redirect()->route('admin.download.index');
    }

    public function edit($id){
        $download=$this->downloadModel::find($id);
        return view('Admin.download.edit',compact('download'));

    }

    public function update($request)
    {
        $request->validate([
            'title' => 'required',
        ]);

        if ($request->hasFile('icon')) {
            $filename = time() . '.' . $request->icon->extension();
            $icons =  $this->uploadImage($request->icon, $filename, 'download');
            $icon= 'images/download/'.$icons;

        }
        $download =  $this->downloadModel::find($request->id);
        $download->update([
            'title'             =>  $request->title,
            'icon'       =>   $icon  ?? $download->icon,
        ]);
        Alert::success('success', ' download  updated Successfully');
        return redirect()->route('admin.download.index');
    }

    public function  destroy($id){
        $download=$this->downloadModel::find($id);

        if($download){
            $download->delete();
            return  1;
        }

       return 0 ;

    }





}
