<?php

namespace App\Http\Repositories\Admin\Auth;

use App\Models\User;
use App\Models\Admin;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Session;
use App\Http\Interfaces\Admin\Auth\AuthInterface;

class AuthRepository implements AuthInterface{


    protected $userModel;

    public function __construct(Admin $adminmodel )
    {
        $this->userModel=$adminmodel;
    }

    public function registerPage(){

        //

    }

    public function register($request){

    //
    }


    public function loginPage()
    {
        if (auth('admin')->check()) {
        return redirect('/admin');
    }
        return view('Admin.Auth.login');
    }
  public function login($request){
    $credintials= $request->only('email','password');
    if(Auth::guard('admin')->attempt($credintials)){
      return redirect('/admin');
    }  else{
      return redirect()->back()->withErrors(['error' => 'login with valied email']);
    }
  }

  public function logout(){

    auth()->guard('admin')->logout();
    Session::flush();
    return redirect()->route('admin.login');
  }
}
