<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Interfaces\Admin\TestQuestionInterface;
use App\Http\Requests\Admin\TestQuestions\CreateTestQuestionRequest;
use App\Http\Requests\Admin\TestQuestions\UpdateTestQuestionRequest;

class TestQuestionController extends Controller
{
    protected $testQuestionInterface;

    public function __construct(TestQuestionInterface $testQuestionInterface)
    {
        $this->testQuestionInterface =$testQuestionInterface;
    }

    public function index(){
        return $this->testQuestionInterface->index();
    }

    public function show($id){
     return $this->testQuestionInterface->show($id);
    }

    public function create(){
         return $this->testQuestionInterface->create();
    }

    public function store(CreateTestQuestionRequest $request){
         return $this->testQuestionInterface->store($request);
    }

    public function edit($id){
         return $this->testQuestionInterface->edit($id);
    }

    public function update(UpdateTestQuestionRequest $request){
         return $this->testQuestionInterface->update($request);
    }

    public function  destroy($id){
         return $this->testQuestionInterface->destroy($id);
    }

    public function  status(Request $request){
        return $this->testQuestionInterface->status($request);
   }
}
