<?php

namespace App\Http\Controllers\Admin;

use App\Models\Subscribe;
use App\Http\Controllers\Controller;
use RealRashid\SweetAlert\Facades\Alert;
use App\Http\Interfaces\Admin\SubscribeInterface;

class SubscribeController extends Controller
{
    private SubscribeInterface $subscribeRepository;

    public function __construct(SubscribeInterface $subscribeRepository)
    {
        $this->subscribeRepository = $subscribeRepository;
    }

    public function index()
    {
        $subscribes = $this->subscribeRepository->index();
        return view('Admin.subscribe.index', compact('subscribes'));
    }

    public function destroy(Subscribe $subscribe)
    {
        $this->subscribeRepository->delete($subscribe);
        Alert::success('success', 'Subscribe deleted successfully');
        return back();
    }
}
