<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Interfaces\Admin\StudentInterface;
use App\Http\Requests\Admin\Student\SendNotificationRequest;
use App\Http\Requests\Admin\Students\CreateStudentRequest;
use App\Http\Requests\Admin\Students\UpdateStudentRequest;

class StudentController extends Controller
{
    protected $studentInterface;

    public function __construct(StudentInterface $studentInterface)
    {
        $this->studentInterface = $studentInterface;
    }

    public function index()
    {
        return $this->studentInterface->index();
    }


    public function create()
    {
        return $this->studentInterface->create();
    }

    public function store(CreateStudentRequest $request)
    {
        return $this->studentInterface->store($request);
    }

    public function edit($id)
    {
        return $this->studentInterface->edit($id);
    }

    public function update(UpdateStudentRequest $request)
    {
        return $this->studentInterface->update($request);
    }

    public function  destroy($id)
    {
        return $this->studentInterface->destroy($id);
    }

    public function sendNotification(SendNotificationRequest $request)
    {
        return $this->studentInterface->sendNotification($request);
    }

    public function notification($id)
    {
        return $this->studentInterface->notification($id);
    }


    public function import()
    {
        return $this->studentInterface->import();
    }

    public function upimport(Request $request)
    {
        return $this->studentInterface->upimport($request);
    }
}
