<?php

namespace App\Http\Controllers\Admin;

use App\Models\Seller;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use RealRashid\SweetAlert\Facades\Alert;
use App\Http\Interfaces\Admin\SellerInterface;
use App\Http\Requests\Admin\Seller\StoreSellerRequest;
use App\Http\Requests\Admin\Seller\UpdateSellerRequest;

class SellerController extends Controller
{
    private $sellerInterface;

    public function __construct(
        SellerInterface $sellerInterface
    ) {
        $this->sellerInterface = $sellerInterface;
    }

    public function index()
    {
        $sellers = Seller::get();
        return view('Admin.seller.index', compact('sellers'));
    }

    public function create()
    {
        return view('Admin.seller.create');
    }

    public function store(StoreSellerRequest $request)
    {
        $this->sellerInterface->store($request->validated());

        Alert::success('success', 'Seller created successfully');
        return redirect()->back();
    }

    public function edit(Seller $seller)
    {
        return view('Admin.seller.edit', compact('seller'));
    }

    public function update(UpdateSellerRequest $request, Seller $seller)
    {
        $this->sellerInterface->update($request->validated(), $seller);

        Alert::success('success', 'Seller updated successfully');
        return redirect()->back();
    }

    public function  destroy(Seller $seller)
    {
        $this->sellerInterface->destroy($seller);

        Alert::success('success', 'Seller deleted successfully');
        return redirect()->back();
    }
}
