<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Interfaces\Admin\SectionInterface;
use App\Http\Requests\Admin\Page\UpdatePageRequest;
use App\Http\Requests\Admin\Section\CreatSectionRequest;

class SectionController extends Controller
{
    protected $sectionInterface;

    public function __construct(SectionInterface $sectionInterface){
        $this->sectionInterface =$sectionInterface;
    }

    public function index(){
        return $this->sectionInterface->index();
    }
    public function create(){
        return $this->sectionInterface->create();
    }

    public function store(CreatSectionRequest $request)
    {
        return $this->sectionInterface->store($request);
    }

    public function edit($id){
        return $this->sectionInterface->edit($id);
    }

    public function update(UpdatePageRequest $request){
        return $this->sectionInterface->update($request);
    }
    public function destroy($id){
        return $this->sectionInterface->destroy($id);
    }
}
