<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Interfaces\Admin\QuizAnswerInterface;
use App\Http\Requests\Admin\Quiz\Answer\CreateQuizAnswerRequest;
use App\Http\Requests\Admin\Quiz\Answer\UpdateQuizAnswerRequest;


class QuizAnswerController extends Controller
{
    protected $quizAnswerInterface;

    public function __construct(QuizAnswerInterface $quizAnswerInterface)
    {
        $this->quizAnswerInterface =$quizAnswerInterface;
    }

    public function create($questionid){
     return $this->quizAnswerInterface->create($questionid);
    }

    public function store( CreateQuizAnswerRequest $request){
     return $this->quizAnswerInterface->store($request);
    }
    public function edit($id){
         return $this->quizAnswerInterface->edit($id);
    }

    public function update(UpdateQuizAnswerRequest $request){
         return $this->quizAnswerInterface->update($request);
    }
    
    public function  destroy($id){
         return $this->quizAnswerInterface->destroy($id);
    }
}
