<?php

namespace App\Http\Controllers\Admin;

use App\Models\Level;
use App\Models\Course;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Interfaces\Admin\LevelInterface;
use App\Http\Requests\Admin\Levels\CreateLevelRequest;
use App\Http\Requests\Admin\Levels\UpdateLevelRequest;


class LevelController extends Controller
{
    protected $levelInterface;

    public function __construct(LevelInterface $levelInterface)
    {
        $this->levelInterface =$levelInterface;
    }

    public function index(){
        return $this->levelInterface->index();
    }
    public function show($id)
    {
        //dd(Course::find($id));
        $levels =  Level::where('course_id', $id)->with('course')->get();
        return view('Admin.level.index',compact('levels', 'id'));

    }


    public function create(){
         return $this->levelInterface->create();
    }

    public function store(CreateLevelRequest $request){
         return $this->levelInterface->store($request);
    }

    public function edit($id){
         return $this->levelInterface->edit($id);
    }

    public function update(UpdateLevelRequest $request){
         return $this->levelInterface->update($request);
    }

    public function  destroy($id){
         return $this->levelInterface->destroy($id);
    }
}
