<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Repositories\Admin\CourseUnitRepository;
use App\Http\Requests\Admin\Units\CreateUnitRequest;
use App\Http\Requests\Admin\Units\UpdateUnitRequest;
use App\Models\Unit;

class CourseUnitController extends Controller
{
    protected $courseUnitInterface;

    public function __construct(CourseUnitRepository $courseUnitInterface)
    {
        $this->courseUnitInterface = $courseUnitInterface;
    }

    public function index($levelId)
    {
        return $this->courseUnitInterface->index($levelId);
    }

    // public function show($id)
    // {
    //     $units =  Unit::where('level_id', $id)->with('level')->get();
    //     return view('Admin.course.unit.index',compact('units', 'id'));

    // }

    public function search(Request $request)
    {
        return $this->courseUnitInterface->search($request);
    }

    public function create($levelId)
    {
        return $this->courseUnitInterface->create($levelId);
    }

    public function store(CreateUnitRequest $request)
    {
        return $this->courseUnitInterface->store($request);
    }

    public function edit($id)
    {
        return $this->courseUnitInterface->edit($id);
    }

    public function update(UpdateUnitRequest $request)
    {
        return $this->courseUnitInterface->update($request);
    }

    public function destroy(Request $request, $id)
    {
        return $this->courseUnitInterface->destroy($request);
    }
}
