<?php

namespace App\Console\Commands;

use App\Models\User;
use Carbon\Carbon;
use Illuminate\Console\Command;

class Streak extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'streak:update';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'update user streak every day if he didnt commit every day it return to zero';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $users = User::get();
        foreach ($users as $user) {
            if ($user->streak_updated  < Carbon::now()->subDays(1)->toDateTimeString()) {

                $user->update([
                    'best_streak' => (($user->streak > $user->best_streak)  ? $user->streak : $user->best_streak),
                    'streak' => 0,
                    'streak_updated' => date("Y-m-d H:i:s")
                ]);
            }
        }
    }
}
