<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Http\Requests\BusinessRegisterRequest;
use App\Http\Requests\RegisterRequest;
use App\Http\Requests\SecondBusinesFormRequest;
use App\Http\Requests\SecondStoreRequest;
use App\Mail\NotifyMail;
use App\Models\company;
use App\Models\Country;
use App\Models\User;
use App\Providers\RouteServiceProvider;
use DateTime;
use Illuminate\Auth\Events\Registered;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use Illuminate\Validation\Rules;

class RegisteredUserController extends Controller
{
    /**
     * Display the registration view.
     *
     * @return \Illuminate\View\View
     */
    public function create()
    {
        return view('auth.register');
    }


    public function RegisterPage()
    {
        $countries = Country::get();
        return view('auth.custom_auth.broker_trader' , compact('countries'));
    }


//resources/views/auth//trader/register.blade.php

    public function RegisterTraderPage()
    {
        return view('auth.custom_auth.trader.register');
    }

    public function RegisterProviderPage()
    {
        return view('auth.custom_auth.provider.register');

    }


    public function firstRegisterationProcess(Request $request)
    {
        dd($request->all());
    }


    /******************business part*****************/
    public function BusinessRegisterPage()
    {
        $countries = Country::get();

        return view('auth.custom_auth.business.first_business_page' , compact('countries'));
    }

    public function BusinessRegisterPageSubmit(BusinessRegisterRequest $request) //like storeshow function
    {
        if ($request->ajax()) {
            $data['errors'] = null;

            if($request->submit_or_show_error === '1') {

                $user = User::create([
                    'email_verified_at' => $request->valid_email,
                    'email' => $request->email,
                    'password' => Hash::make($request->password),
                    'phone' => $request->country_code . $request->phone,
                    'type' => 3,//business

                ]);

                event(new Registered($user));

                Auth::login($user);


                $data['errors'] = 'no';


                if($user) {
                    $data['user'] =1;
                }else{
                    $data['user'] =0;
                }
            }

            return response()->json($data,200);
        }
    }


    public function BusinessRegisterSecondPage()
    {
        return view('auth.custom_auth.business.register');
    }


    /************************************************/

    public function secondBusinessStoreShow($id,SecondBusinesFormRequest  $request)
    {
        //        SecondStoreRequest
        if ($request->ajax()) {

            if(isset($request->service_needed)) {
                $num = explode($request->service_needed, ',');
            }else{
                $num = null;
            }

            $data['errors'] = null;
//         dd($request->all() );
            if($request->submit_or_show_error === '1') {
                if ($num && count($num) > 0 && count($num) < 3) {
                    $user = User::where('id', $id)->update([
//                    'full_name' => $request->first_name . " " . $request->second_name . " " . $request->last_name,
//                 'email' => $request->email,
//                    'name' => $request->name,
//                    'id_number' => $request->id_number,
//                    'date_of_birth' => $request->date_of_birth,
//                    'name_of_broker' => $request->name_of_broker,
                        'heir_name' => $request->heir_name,
                        'service_needed' => $request->service_needed,
                        'experience' => $request->experience,
                        'experience_type' => $request->experience_type,
                        'gender' => $request->gender,
                        'experience_level' => $request->experience_level,

                    ]);

                    $company = company::create([
                        'user_id' => $id,
                        'name' => $request->name,
                        'owner_name' => $request->owner_name,
                        'activity' => $request->activity,
                        'website' => $request->website,
                        'telegram_channel' => $request->telegram_channel,
                        'num_employees' => $request->num_employees,
                        'date_of_establishment' => $request->date_of_establishment,

                    ]);

                    if($company && $user){
                        $data['errors'] = 'no';

                    }
//            event(new Registered($user));

//            Auth::login($user);

//            $data['type'] = $request->type;
                }
            }

            $data = 'yes';

            return response()->json($data,200);
        }



    }

    /*****************end business part**************/



//    const myArr = ['email','password'  ,'password_confirmation'  ,'phone'  ,'type' ,'my_check' ,'valid_email' ,'country_code'];


    /**
     * Handle an incoming registration request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\RedirectResponse
     *
     * @throws \Illuminate\Validation\ValidationException
     */
    public function store(RegisterRequest $request)
    {

//                'password' => 'required|confirmed|string|min:8|confirmed|regex:/^(?=.*?[A-Z])(?=.*?[a-z])(?=.*?[0-9])(?=.*?[#?!@$%^&*-]).{6,}$/',
            $user = User::create([
                'email_verified_at' => $request->valid_email,
                'email' => $request->email,
                'password' => Hash::make($request->password),
                'phone' => $request->country_code . $request->phone,
                'type' => $request->type,
            ]);
            event(new Registered($user));
            Auth::login($user);
            if ($request->type === '1') {
                return redirect(RouteServiceProvider::TRADER);
            } elseif ($request->type === '0') {
                return redirect(RouteServiceProvider::PROVIDER);

            }
    }


    public function sendEmail()
    {
        Mail::to('basma.gamaleldin100@gmail.com')->send(new NotifyMail());
        if (Mail::failures()) {
            return response()->Fail('Sorry! Please try again latter');
        }else{
            return response()->success('Great! Successfully send in your mail');
        }
    }





/*********************************************/

//aja func which shows validation only
    public function storeShow(RegisterRequest $request)
//    public function storeShow(Request $request)

    {
//
        if ($request->ajax()) {
            $data['errors'] = null;

            if($request->submit_or_show_error === '1') {

            $user = User::create([
            'email_verified_at' => $request->valid_email,
                'email' => $request->email,
                'password' => Hash::make($request->password),
                'phone' => $request->country_code . $request->phone,
                'type' => $request->type,

            ]);

                event(new Registered($user));
                Auth::login($user);
                $data['errors'] = 'no';

            }

            $data['type'] = $request->type;
            return response()->json($data,200);
        }
    }





    /*****************************************/

    public function secondStoreShow($id,SecondStoreRequest  $request)
    {
//        SecondStoreRequest
        if ($request->ajax()) {

            if($request->service_needed) {
                $num = explode($request->service_needed, ',');
            }else{
                $num = '';
            }
//         dd($request->all() );
//         if($num && count($num) >0 && count($num) <3) {
//             $user = User::where('id', $id)->update([
//                 'full_name' => $request->first_name . " " . $request->second_name . " " . $request->last_name,
////                 'email' => $request->email,
//                 'name' => $request->name,
//                 'id_number' => $request->id_number,
//                 'date_of_birth' => $request->date_of_birth,
//                 'name_of_broker' => $request->name_of_broker,
//                 'heir_name' => $request->heir_name,
//                 'service_needed' => $request->service_needed,
//                 'experience' => $request->experience,
//                 'experience_type' => $request->experience_type,
//                 'gender' => $request->gender,
//                 'experience_level' => $request->experience_level,
//
//             ]);
//
////            event(new Registered($user));
//
////            Auth::login($user);
//
////            $data['type'] = $request->type;
//         }

            $data = 'success';

            return response()->json($data,200);
        }


    }

    /******************************************/



    /****************************************/

    public function secondStoreSubmit($id,SecondStoreRequest  $request)
    {
//        SecondStoreRequest
//        if ($request->ajax()) {


        $data['errors'] = null; //this variable take null  when the user clicks any input except submit button to show erros only

        if($request->submit_or_show_error === '1') { //this request is sent when the user clicks on submit button only
            $data['errors'] = 'no'; //this variable take 'no'  when the user clicks on submit button only

            if ($request->service_needed) {
                $num = explode($request->service_needed, ',');
            } else {
                $num = '';
            }
//         dd($request->all() );
            if ($num && count($num) > 0 && count($num) < 3) {
                $user = User::where('id', $id)->update([
                    'full_name' => $request->first_name . " " . $request->second_name . " " . $request->last_name,
//                 'email' => $request->email,
                    'name' => $request->name,
                    'id_number' => $request->id_number,
                    'date_of_birth' => $request->date_of_birth,
                    'name_of_broker' => $request->name_of_broker,
                    'heir_name' => $request->heir_name,
                    'service_needed' => $request->service_needed,
                    'experience' => $request->experience,
                    'experience_type' => $request->experience_type,
                    'gender' => $request->gender,
                    'experience_level' => $request->experience_level,

                ]);

//            event(new Registered($user));

//            Auth::login($user);

//            $data['type'] = $request->type;
            }

            $data = 'success submitted';
        }

            return response()->json($data,200);
//        }


    }

    /********************************/
//    public function sendEmailNow()
//    {
//
//        $num = rand(1,10000);
//        $details = [
//            'title' => 'Mail from ItSolutionStuff.com',
//            'body' => 'This is for your code :  '.$num
//        ];
//
//
//        Mail::to('your_receiver_email@gmail.com')->send(new \App\Mail\MyTestMail($details));
//        $date_of_sending = now()->format ('Y-m-d');
//        return response()->json([$num , $date_of_sending] , 200 );
////            dd("Email is Sent.");
//    }

    public function sendEmailNow(Request $request)
    {
//        $now_date = now();
//        $old = date('Y-m-d H:i:s',strtotime($request->valid_email_first));
//        if($request->session()->has('email_sent')) {
////         $m =  strtotime(date("Y/m/d H:i:s +30 second")) -$request->session()->get('email_sent');
////            dd($request->session()->get('email_sent') - strtotime(date("Y/m/d H:i:s")));
//
//                if(  $request->session()->get('email_sent') - strtotime(date("Y/m/d H:i:s"))  > (strtotime('+30') - strtotime(date("Y/m/d H:i:s")))){
////              dd(['+30'=>strtotime("+30 seconds")  ,'sesion'=>  $request->session()->get('email_sent') , 'now'=> strtotime(date("Y/m/d H:i:s"))]);
//            $request->session()->forget('email_sent');
//          }
//        }
//


//        $request->session()->put('email_sent', strtotime(date("Y/m/d H:i:s")));
//        dd(  (strtotime('+30')) - strtotime(date("Y/m/d H:i:s")));

//        if($request->valid_email_first - $now_date) {
            $num = rand(1, 10000);
        setcookie('date' , strtotime(date("Y/m/d H:i:s")) , time() + 30 , '/');

        $details = [
                'title' => 'Mail from ItSolutionStuff.com',
                'body' => 'This is for your code :  ' . $num
            ];

//        dd($request->session()->get('email_sent'));

            Mail::to('your_receiver_email@gmail.com')->send(new \App\Mail\MyTestMail($details));
            $date_of_sending = now();

        return response()->json([$num, $date_of_sending], 200);
        }
//            dd("Email is Sent.");
//    }

    public function checkEmail(Request $request)
    {

//        if($request->code === $request->original_code){
//
//
//            $valid_email = now ()->format ('Y-m-d') ;
//            return response()->json( $valid_email, 200);
//        }else{
//            return response()->json( 'no', 300);
//
//        }

        if(isset($_COOKIE['date']) && !((strtotime(date("Y/m/d H:i:s")) - $_COOKIE['date']) > 30 ) && ($request->code === $request->original_code)) {
                $valid_email = now()->format('Y-m-d');
                return response()->json($valid_email, 200);
            } elseif(isset($_COOKIE['date']) && !((strtotime(date("Y/m/d H:i:s")) - $_COOKIE['date']) > 30 ) && ($request->code !== $request->original_code)) {
                return response()->json('no', 300);
        }else{
            return response()->json('the code you entered is wrong or is expired, try again', 301);
        }

    }

}
