<?php

namespace App\Imports;

use App\Models\User;
use App\Models\Country;
use Illuminate\Support\Facades\Hash;
use Maatwebsite\Excel\Concerns\ToModel;
use Illuminate\Support\Facades\Validator;

class StudentImport implements ToModel
{
    /**
     * @param array $row
     *
     * @return \Illuminate\rowbase\Eloquent\Model|null
     */
    public function model(array $row)
    {
        $row = Validator::make($row, [
            '0' => 'nullable|string',
            '1' => 'nullable|email|unique:users,email',
            '2' => 'nullable|string',
            '3' => 'nullable|exists:countries,country',
            '4' => 'nullable|string|in:email_verified,email_not_verified',
            '5' => 'nullable|string|in:active,inactive',
        ], [
            '0.string'  => 'This field name must be a string',
            '1.email'  => 'This field email must be a valid email address',
            '2.string'  => 'This field password must be a string',
            '3.exists'  => 'This field country does not exists',
            '4.string'  => 'This field verification must be a string',
            '5.string'  => 'This field activation must be a string',

            '1.unique'  => 'This field email taken',
            '4.string'  => 'This field verification must be email_verified or email_not_verified',
            '5.string'  => 'This field activation must be active or inactive',


        ])->validate();

        $data = [];
        $data['name'] = $row[0];
        $data['email'] = $row[1];
        $data['password'] = Hash::make($row[2]);
        $data['country_id'] = Country::where('country', $row[3])->select(['id'])->first()?->id;
        $data['email_verified_at'] = $row[4] == 'email_verified' ? now() : null;
        $data['is_active'] = $row[5] == 'active';

        if (isset($data['email']) && !is_null($data['email'])) {
            return User::create($data);
        }


        return;
    }
}
